/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.equals.EqualsHelper;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphRelation;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GraphIterator
implements IIterableIterator<IMutableGraphNode> {
    private final ICommonsSet<String> m_aHandledObjects = new CommonsHashSet();
    private final Iterator<IMutableGraphNode> m_aIter;
    private boolean m_bHasCycles = false;

    public GraphIterator(@Nonnull IMutableGraphNode iMutableGraphNode) {
        ValueEnforcer.notNull((Object)iMutableGraphNode, (String)"startNode");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this._traverseDFS(iMutableGraphNode, (ICommonsList<IMutableGraphNode>)commonsArrayList);
        this.m_aIter = commonsArrayList.iterator();
    }

    private void _traverseDFS(@Nonnull IMutableGraphNode iMutableGraphNode, @Nonnull ICommonsList<IMutableGraphNode> iCommonsList) {
        this.m_aHandledObjects.add(iMutableGraphNode.getID());
        iCommonsList.add((Object)iMutableGraphNode);
        for (IMutableGraphRelation iMutableGraphRelation : iMutableGraphNode.getAllRelations()) {
            boolean bl = this.m_aHandledObjects.add(iMutableGraphRelation.getID());
            for (IMutableGraphNode iMutableGraphNode2 : iMutableGraphRelation.getAllConnectedNodes()) {
                if (EqualsHelper.identityEqual((Object)iMutableGraphNode2, (Object)iMutableGraphNode)) continue;
                if (!this.m_aHandledObjects.contains(iMutableGraphNode2.getID())) {
                    this._traverseDFS(iMutableGraphNode2, iCommonsList);
                    continue;
                }
                if (!bl) continue;
                this.m_bHasCycles = true;
            }
        }
    }

    public boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Nullable
    public IMutableGraphNode next() {
        return this.m_aIter.next();
    }

    public boolean hasCycles() {
        return this.m_bHasCycles;
    }
}

