/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.graph.IMutableBaseGraphObject;
import com.helger.graph.impl.GraphObjectIDFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractBaseGraphObject
implements IMutableBaseGraphObject {
    private final String m_sID;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    public AbstractBaseGraphObject(@Nullable String string) {
        this.m_sID = StringHelper.hasNoText((String)string) ? GraphObjectIDFactory.createNewGraphObjectID() : string;
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    @ReturnsMutableObject
    public final AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBaseGraphObject abstractBaseGraphObject = (AbstractBaseGraphObject)object;
        return this.m_sID.equals(abstractBaseGraphObject.m_sID) && this.m_aAttrs.equals(abstractBaseGraphObject.m_aAttrs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append(this.m_aAttrs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Attrs", this.m_aAttrs).getToString();
    }
}

