/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.domain.IHasStartAndEnd;
import com.helger.datetime.helper.PDTFactory;
import java.time.LocalDate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ILocalDatePeriod
extends IHasStartAndEnd<LocalDate> {
    public static boolean isInside(@Nullable LocalDate localDate, boolean bl, @Nullable LocalDate localDate2, boolean bl2, @NonNull LocalDate localDate3) {
        ValueEnforcer.notNull((Object)localDate3, (String)"QueryDT");
        if (localDate != null && (bl ? localDate3.compareTo(localDate) < 0 : localDate3.compareTo(localDate) <= 0)) {
            return false;
        }
        return localDate2 == null || !(bl2 ? localDate3.compareTo(localDate2) > 0 : localDate3.compareTo(localDate2) >= 0);
    }

    default public boolean isInPeriod(boolean bl, @NonNull LocalDate localDate) {
        return ILocalDatePeriod.isInside((LocalDate)this.getStart(), bl, (LocalDate)this.getEnd(), bl, localDate);
    }

    default public boolean isInPeriodIncl(@NonNull LocalDate localDate) {
        return this.isInPeriod(true, localDate);
    }

    default public boolean isNowInPeriodIncl() {
        return this.isInPeriodIncl(PDTFactory.getCurrentLocalDate());
    }

    default public boolean isInPeriodExcl(@NonNull LocalDate localDate) {
        return this.isInPeriod(false, localDate);
    }

    default public boolean isNowInPeriodExcl() {
        return this.isInPeriodExcl(PDTFactory.getCurrentLocalDate());
    }

    public static boolean hasOverlap(@Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nullable LocalDate localDate3, @Nullable LocalDate localDate4, boolean bl) {
        if (localDate3 != null && ILocalDatePeriod.isInside(localDate, bl, localDate2, bl, localDate3)) {
            return true;
        }
        if (localDate4 != null && ILocalDatePeriod.isInside(localDate, bl, localDate2, bl, localDate4)) {
            return true;
        }
        if (localDate != null && ILocalDatePeriod.isInside(localDate3, bl, localDate4, bl, localDate)) {
            return true;
        }
        return localDate2 != null && ILocalDatePeriod.isInside(localDate3, bl, localDate4, bl, localDate2);
    }

    default public boolean isOverlappingWith(@NonNull ILocalDatePeriod iLocalDatePeriod, boolean bl) {
        return ILocalDatePeriod.hasOverlap((LocalDate)this.getStart(), (LocalDate)this.getEnd(), (LocalDate)iLocalDatePeriod.getStart(), (LocalDate)iLocalDatePeriod.getEnd(), bl);
    }

    default public boolean isOverlappingWithIncl(@NonNull ILocalDatePeriod iLocalDatePeriod) {
        return this.isOverlappingWith(iLocalDatePeriod, true);
    }

    default public boolean isOverlappingWithExcl(@NonNull ILocalDatePeriod iLocalDatePeriod) {
        return this.isOverlappingWith(iLocalDatePeriod, false);
    }
}

