/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.expiration.IExpirable;
import com.helger.datetime.helper.PDTFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ExpiringObject<DATATYPE>
implements IExpirable {
    private final DATATYPE m_aObj;
    private final LocalDateTime m_aExpirationDT;

    public ExpiringObject(@Nullable DATATYPE DATATYPE, @NonNull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"ExpirationDT");
        this.m_aObj = DATATYPE;
        this.m_aExpirationDT = localDateTime;
    }

    public final @Nullable DATATYPE getObject() {
        return this.m_aObj;
    }

    @Override
    public final @NonNull LocalDateTime getExpirationDateTime() {
        return this.m_aExpirationDT;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Object", this.m_aObj).append("ExpirationDT", (Object)this.m_aExpirationDT).getToString();
    }

    public static <DATATYPE> @NonNull ExpiringObject<DATATYPE> ofDuration(@Nullable DATATYPE DATATYPE, @NonNull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"ValidityDuration");
        ValueEnforcer.isFalse(duration::isNegative, (String)"ValidityDuration must not be negative");
        return new ExpiringObject<DATATYPE>(DATATYPE, PDTFactory.getCurrentLocalDateTime().plus(duration));
    }
}

