/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IExpirable;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpiringObject<DATATYPE>
implements IExpirable {
    private final DATATYPE m_aObj;
    private final LocalDateTime m_aExpirationDT;

    public ExpiringObject(@Nullable DATATYPE DATATYPE, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"ExpirationDT");
        this.m_aObj = DATATYPE;
        this.m_aExpirationDT = localDateTime;
    }

    @Nullable
    public final DATATYPE getObject() {
        return this.m_aObj;
    }

    @Override
    @Nonnull
    public final LocalDateTime getExpirationDateTime() {
        return this.m_aExpirationDT;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Object", this.m_aObj).append("ExpirationDT", (Object)this.m_aExpirationDT).getToString();
    }

    @Nonnull
    public static <DATATYPE> ExpiringObject<DATATYPE> ofDuration(@Nullable DATATYPE DATATYPE, @Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"ValidityDuration");
        ValueEnforcer.isFalse(duration::isNegative, (String)"ValidityDuration must not be negative");
        return new ExpiringObject<DATATYPE>(DATATYPE, PDTFactory.getCurrentLocalDateTime().plus(duration));
    }
}

