/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.cli.CmdLineParseException;
import com.helger.cli.ECmdLineParseError;
import com.helger.cli.IOptionBase;
import com.helger.cli.Option;
import com.helger.cli.OptionGroup;
import com.helger.cli.Options;
import com.helger.cli.ParsedCmdLine;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdLineParser {
    public static final String PREFIX_SHORT_OPT = "-";
    public static final String PREFIX_LONG_OPT = "--";
    private static final Logger LOGGER = LoggerFactory.getLogger(CmdLineParser.class);
    private final Options m_aOptions;

    public CmdLineParser(@NonNull Options options) {
        ValueEnforcer.notNull((Object)options, (String)"Options");
        this.m_aOptions = options;
    }

    private static @Nullable MatchedOption _findMatchingOption(@NonNull ICommonsMap<String, Option> iCommonsMap, @Nonempty @NonNull String string) {
        String string2 = string;
        String string3 = "";
        int n = 0;
        if (string2.startsWith(PREFIX_LONG_OPT)) {
            n = PREFIX_LONG_OPT.length();
        } else if (string2.startsWith(PREFIX_SHORT_OPT)) {
            n = PREFIX_SHORT_OPT.length();
        }
        if (n > 0) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n);
        }
        if (string2.length() == 0) {
            return null;
        }
        Option option = (Option)iCommonsMap.get((Object)string2);
        if (option != null) {
            return new MatchedOption(option, string3 + string2);
        }
        while ((string2 = string2.substring(0, string2.length() - 1)).length() != 0) {
            option = (Option)iCommonsMap.get((Object)string2);
            if (option == null) continue;
            return new MatchedOption(option, string3 + string2);
        }
        return null;
    }

    private static @NonNull String _getDisplayName(@NonNull Option option) {
        Object object = "";
        if (option.hasShortOpt()) {
            object = (String)object + PREFIX_SHORT_OPT + option.getShortOpt();
        }
        if (option.hasLongOpt()) {
            if (((String)object).length() > 0) {
                object = (String)object + "/";
            }
            object = (String)object + PREFIX_LONG_OPT + option.getLongOpt();
        }
        return object;
    }

    private static @NonNull String _getDisplayName(@NonNull OptionGroup optionGroup) {
        return "[" + StringImplode.getImplodedMapped((String)" | ", (Collection)((Object)optionGroup), CmdLineParser::_getDisplayName) + "]";
    }

    public static @NonNull ParsedCmdLine parseStatic(@NonNull Options options, @Nullable String[] stringArray) throws CmdLineParseException {
        IOptionBase iOptionBase;
        Object object;
        Object object2;
        ValueEnforcer.notNull((Object)options, (String)"Options");
        ICommonsList<Option> iCommonsList = options.getAllResolvedOptions();
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Option option : iCommonsList) {
            if (option.hasShortOpt()) {
                commonsHashMap.put((Object)option.getShortOpt(), (Object)option);
            }
            if (!option.hasLongOpt()) continue;
            commonsHashMap.put((Object)option.getLongOpt(), (Object)option);
        }
        ParsedCmdLine parsedCmdLine = new ParsedCmdLine();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = StringHelper.trim((String)stringArray[i]);
                if (!StringHelper.isNotEmpty((String)object2)) continue;
                object = CmdLineParser._findMatchingOption((ICommonsMap<String, Option>)commonsHashMap, (String)object2);
                if (object != null) {
                    String string;
                    iOptionBase = ((MatchedOption)object).m_aOption;
                    OptionGroup optionGroup = options.getOptionGroup((Option)iOptionBase);
                    if (optionGroup != null && !commonsHashSet.add((Object)optionGroup)) {
                        throw new CmdLineParseException(ECmdLineParseError.ANOTHER_OPTION_OF_GROUP_ALREADY_PRESENT, optionGroup, "The option " + CmdLineParser._getDisplayName((Option)iOptionBase) + " cannot be selected because another option of the same group is already present!");
                    }
                    if (!((Option)iOptionBase).isRepeatable() && parsedCmdLine.hasOption(iOptionBase)) {
                        throw new CmdLineParseException(ECmdLineParseError.NON_REPEATABLE_OPTION_OCCURS_MORE_THAN_ONCE, (Option)iOptionBase, "The option " + CmdLineParser._getDisplayName((Option)iOptionBase) + " was already specified but cannot be contained more than once!");
                    }
                    String string2 = ((String)object2).substring(((MatchedOption)object).m_sMatchedText.length());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Matched '" + ((MatchedOption)object).m_sMatchedText + "' to " + CmdLineParser._getDisplayName((Option)iOptionBase) + (String)(string2.length() > 0 ? "; rest is '" + string2 + "'" : ""));
                    }
                    int n = ((Option)iOptionBase).getMinArgCount();
                    int n2 = ((Option)iOptionBase).getMaxArgCount();
                    boolean bl = ((Option)iOptionBase).hasInfiniteArgs();
                    CommonsArrayList commonsArrayList = new CommonsArrayList();
                    if (StringHelper.isNotEmpty((String)string2)) {
                        if (((Option)iOptionBase).hasValueSeparator()) {
                            StringHelper.explode((char)((Option)iOptionBase).getValueSeparator(), (String)string2, (int)(bl ? -1 : n2 - commonsArrayList.size()), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
                        } else {
                            commonsArrayList.add((Object)string2);
                        }
                    }
                    while (i + 1 < stringArray.length && ((Option)iOptionBase).canHaveMoreValues(commonsArrayList.size()) && (CmdLineParser._findMatchingOption((ICommonsMap<String, Option>)commonsHashMap, string = StringHelper.trim((String)stringArray[i + 1])) == null || commonsArrayList.size() < n)) {
                        ++i;
                        if (!StringHelper.isNotEmpty((String)string)) continue;
                        if (((Option)iOptionBase).hasValueSeparator()) {
                            StringHelper.explode((char)((Option)iOptionBase).getValueSeparator(), (String)string, (int)(bl ? -1 : n2 - commonsArrayList.size()), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
                            continue;
                        }
                        commonsArrayList.add((Object)string);
                    }
                    if (commonsArrayList.size() < n) {
                        throw new CmdLineParseException(ECmdLineParseError.TOO_LITTLE_REQUIRED_VALUES, (Option)iOptionBase, CmdLineParser._getDisplayName((Option)iOptionBase) + " requires at least " + n + " values but has only " + commonsArrayList.size());
                    }
                    parsedCmdLine.internalAddValue(iOptionBase, (ICommonsList<String>)commonsArrayList);
                    if (optionGroup == null) continue;
                    parsedCmdLine.internalAddValue(optionGroup, (ICommonsList<String>)commonsArrayList);
                    continue;
                }
                parsedCmdLine.internalAddUnhandledToken((String)object2);
            }
        }
        Iterator<IOptionBase> iterator = options.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!object2.isRequired()) continue;
            if (object2 instanceof Option) {
                object = (Option)object2;
                if (parsedCmdLine.hasOption((IOptionBase)object)) continue;
                throw new CmdLineParseException(ECmdLineParseError.REQUIRED_OPTION_IS_MISSING, (Option)object, "The option " + CmdLineParser._getDisplayName((Option)object) + " is required but is missing!");
            }
            iOptionBase = (OptionGroup)object2;
            if (parsedCmdLine.hasOption(iOptionBase)) continue;
            throw new CmdLineParseException(ECmdLineParseError.REQUIRED_OPTION_IS_MISSING, (OptionGroup)iOptionBase, "An option of " + CmdLineParser._getDisplayName((OptionGroup)iOptionBase) + " is required but is missing!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsed command line args " + Arrays.toString(stringArray) + " to " + String.valueOf(parsedCmdLine));
        }
        return parsedCmdLine;
    }

    public @NonNull ParsedCmdLine parse(@Nullable String[] stringArray) throws CmdLineParseException {
        return CmdLineParser.parseStatic(this.m_aOptions, stringArray);
    }

    public @Nullable ParsedCmdLine parseOrNull(@Nullable String[] stringArray) {
        try {
            return this.parse(stringArray);
        }
        catch (CmdLineParseException cmdLineParseException) {
            return null;
        }
    }

    private static final class MatchedOption {
        private final Option m_aOption;
        private final String m_sMatchedText;

        MatchedOption(@NonNull Option option, @Nonempty @NonNull String string) {
            this.m_aOption = option;
            this.m_sMatchedText = string;
        }
    }
}

