/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import jakarta.annotation.Nonnull;

final class OptionValidator {
    private OptionValidator() {
    }

    static void validateShortOption(@Nonnull String string) {
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!OptionValidator._isValidShortOpt(c)) {
                throw new IllegalArgumentException("Illegal option name '" + c + "'");
            }
        } else {
            for (char c : string.toCharArray()) {
                if (OptionValidator._isValidChar(c)) continue;
                throw new IllegalArgumentException("The option '" + string + "' contains the illegal character '" + c + "'");
            }
        }
    }

    private static boolean _isValidShortOpt(char c) {
        return OptionValidator._isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean _isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

