/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.trait;

import com.helger.base.string.StringHelper;
import com.helger.base.trait.IAddableByTrait;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.base.trait.IHasTypeConverterTo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;

public interface IGenericMapAdderTrait<KEYTYPE, VALUETYPE extends IAddableByTrait, IMPLTYPE extends IGenericMapAdderTrait<KEYTYPE, VALUETYPE, IMPLTYPE>>
extends IHasTypeConverterTo<VALUETYPE>,
IGenericImplTrait<IMPLTYPE> {
    @Nonnull
    public IMPLTYPE add(@Nonnull KEYTYPE var1, @Nonnull VALUETYPE var2);

    @Nonnull
    default public IMPLTYPE addIf(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE, @Nonnull Predicate<? super VALUETYPE> predicate) {
        if (predicate.test(VALUETYPE)) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addIf(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE, @Nonnull BooleanSupplier booleanSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addIfNotNull(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (VALUETYPE != null) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, @Nullable Object object) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(object)));
    }

    @Nonnull
    default public IMPLTYPE addIf(@Nonnull KEYTYPE KEYTYPE, @Nullable Object object, @Nonnull BooleanSupplier booleanSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            this.add(KEYTYPE, object);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public <T> IMPLTYPE addIf(@Nonnull KEYTYPE KEYTYPE, @Nullable T t, @Nonnull Predicate<? super T> predicate) {
        if (predicate.test(t)) {
            this.add(KEYTYPE, t);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addIfNotNull(@Nonnull KEYTYPE KEYTYPE, @Nullable Object object) {
        if (object != null) {
            this.add(KEYTYPE, object);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addIfNotEmpty(@Nonnull KEYTYPE KEYTYPE, @Nullable String string) {
        if (StringHelper.isNotEmpty(string)) {
            this.add(KEYTYPE, string);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull Map.Entry<? extends KEYTYPE, ?> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, boolean bl) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(bl)));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, char c) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(c)));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, double d) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(d)));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, int n) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(n)));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull KEYTYPE KEYTYPE, long l) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(l)));
    }

    @Nonnull
    default public IMPLTYPE addAll(@Nullable Iterable<Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : iterable) {
                this.add(entry.getKey(), (VALUETYPE)((IAddableByTrait)entry.getValue()));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAllAny(@Nullable Map<? extends KEYTYPE, ?> map) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, ?> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAllAny(@Nullable Iterable<Map.Entry<KEYTYPE, ?>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, ?> entry : iterable) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public <SRCVALUETYPE> IMPLTYPE addAllMapped(@Nullable Map<? extends KEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCVALUETYPE, VALUETYPE> function) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.add(entry.getKey(), (VALUETYPE)((IAddableByTrait)function.apply(entry.getValue())));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    @Nonnull
    default public <SRCKEYTYPE, SRCVALUETYPE> IMPLTYPE addAllMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, KEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, VALUETYPE> function2) {
        if (map != null) {
            for (Map.Entry<SRCKEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.add(function.apply(entry.getKey()), (VALUETYPE)((IAddableByTrait)function2.apply(entry.getValue())));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }
}

