/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.fragment.app.Fragment;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.slide.ButtonCtaSlide;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import com.heinrichreimersoftware.materialintro.slide.SimpleSlideActivity;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.view.parallax.ParallaxSlideFragment;
import java.util.ArrayList;
import java.util.Arrays;

public class SimpleSlide
implements Slide,
RestorableSlide,
ButtonCtaSlide {
    private static final int DEFAULT_PERMISSIONS_REQUEST_CODE = 34;
    private SimpleSlideFragment fragment;
    private final long id;
    private final CharSequence title;
    @StringRes
    private final int titleRes;
    private final CharSequence description;
    @StringRes
    private final int descriptionRes;
    @DrawableRes
    private final int imageRes;
    @LayoutRes
    private final int layoutRes;
    @ColorRes
    private final int backgroundRes;
    @ColorRes
    private final int backgroundDarkRes;
    private final boolean canGoForward;
    private final boolean canGoBackward;
    private String[] permissions;
    private int permissionsRequestCode;
    private CharSequence buttonCtaLabel = null;
    @StringRes
    private int buttonCtaLabelRes = 0;
    private View.OnClickListener buttonCtaClickListener = null;

    protected SimpleSlide(Builder builder) {
        this.fragment = SimpleSlideFragment.newInstance(builder.id, builder.title, builder.titleRes, builder.description, builder.descriptionRes, builder.imageRes, builder.backgroundRes, builder.layoutRes, builder.permissionsRequestCode);
        this.id = builder.id;
        this.title = builder.title;
        this.titleRes = builder.titleRes;
        this.description = builder.description;
        this.descriptionRes = builder.descriptionRes;
        this.imageRes = builder.imageRes;
        this.layoutRes = builder.layoutRes;
        this.backgroundRes = builder.backgroundRes;
        this.backgroundDarkRes = builder.backgroundDarkRes;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
        this.permissions = builder.permissions;
        this.permissionsRequestCode = builder.permissionsRequestCode;
        this.buttonCtaLabel = builder.buttonCtaLabel;
        this.buttonCtaLabelRes = builder.buttonCtaLabelRes;
        this.buttonCtaClickListener = builder.buttonCtaClickListener;
        this.updatePermissions();
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public void setFragment(Fragment fragment) {
        if (fragment instanceof SimpleSlideFragment) {
            this.fragment = (SimpleSlideFragment)fragment;
        }
    }

    @Override
    public int getBackground() {
        return this.backgroundRes;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDarkRes;
    }

    @Override
    public boolean canGoForward() {
        this.updatePermissions();
        return this.canGoForward && this.permissions == null;
    }

    @Override
    public boolean canGoBackward() {
        return this.canGoBackward;
    }

    @Override
    public View.OnClickListener getButtonCtaClickListener() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaClickListener;
        }
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (SimpleSlide.this.fragment.getActivity() != null) {
                    ActivityCompat.requestPermissions((Activity)SimpleSlide.this.fragment.getActivity(), (String[])SimpleSlide.this.permissions, (int)SimpleSlide.this.permissionsRequestCode);
                }
            }
        };
    }

    @Override
    public CharSequence getButtonCtaLabel() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaLabel;
        }
        Context context = this.fragment.getContext();
        if (context != null) {
            return context.getResources().getQuantityText(R.plurals.mi_label_grant_permission, this.permissions.length);
        }
        return null;
    }

    @Override
    public int getButtonCtaLabelRes() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaLabelRes;
        }
        return 0;
    }

    private synchronized void updatePermissions() {
        if (this.permissions != null) {
            ArrayList<String> permissionsNotGranted = new ArrayList<String>();
            for (String permission : this.permissions) {
                if (this.fragment.getContext() != null && ContextCompat.checkSelfPermission((Context)this.fragment.getContext(), (String)permission) == 0) continue;
                permissionsNotGranted.add(permission);
            }
            this.permissions = permissionsNotGranted.size() > 0 ? permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]) : null;
        } else {
            this.permissions = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSlide that = (SimpleSlide)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.titleRes != that.titleRes) {
            return false;
        }
        if (this.descriptionRes != that.descriptionRes) {
            return false;
        }
        if (this.imageRes != that.imageRes) {
            return false;
        }
        if (this.layoutRes != that.layoutRes) {
            return false;
        }
        if (this.backgroundRes != that.backgroundRes) {
            return false;
        }
        if (this.backgroundDarkRes != that.backgroundDarkRes) {
            return false;
        }
        if (this.canGoForward != that.canGoForward) {
            return false;
        }
        if (this.canGoBackward != that.canGoBackward) {
            return false;
        }
        if (this.permissionsRequestCode != that.permissionsRequestCode) {
            return false;
        }
        if (this.buttonCtaLabelRes != that.buttonCtaLabelRes) {
            return false;
        }
        if (this.fragment != null ? !this.fragment.equals(that.fragment) : that.fragment != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!Arrays.equals(this.permissions, that.permissions)) {
            return false;
        }
        if (this.buttonCtaLabel != null ? !this.buttonCtaLabel.equals(that.buttonCtaLabel) : that.buttonCtaLabel != null) {
            return false;
        }
        return this.buttonCtaClickListener != null ? this.buttonCtaClickListener.equals(that.buttonCtaClickListener) : that.buttonCtaClickListener == null;
    }

    public int hashCode() {
        int result = this.fragment != null ? this.fragment.hashCode() : 0;
        result = 31 * result + Long.valueOf(this.id).hashCode();
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + this.titleRes;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.descriptionRes;
        result = 31 * result + this.imageRes;
        result = 31 * result + this.layoutRes;
        result = 31 * result + this.backgroundRes;
        result = 31 * result + this.backgroundDarkRes;
        result = 31 * result + (this.canGoForward ? 1 : 0);
        result = 31 * result + (this.canGoBackward ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.permissions);
        result = 31 * result + this.permissionsRequestCode;
        result = 31 * result + (this.buttonCtaLabel != null ? this.buttonCtaLabel.hashCode() : 0);
        result = 31 * result + this.buttonCtaLabelRes;
        result = 31 * result + (this.buttonCtaClickListener != null ? this.buttonCtaClickListener.hashCode() : 0);
        return result;
    }

    public static class SimpleSlideFragment
    extends ParallaxSlideFragment {
        private static final String ARGUMENT_ID = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_ID";
        private static final String ARGUMENT_TITLE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE";
        private static final String ARGUMENT_TITLE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE_RES";
        private static final String ARGUMENT_DESCRIPTION = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION";
        private static final String ARGUMENT_DESCRIPTION_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION_RES";
        private static final String ARGUMENT_IMAGE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_IMAGE_RES";
        private static final String ARGUMENT_BACKGROUND_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_RES";
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_PERMISSIONS_REQUEST_CODE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_PERMISSIONS_REQUEST_CODE";
        private TextView titleView = null;
        private TextView descriptionView = null;
        private ImageView imageView = null;

        public static SimpleSlideFragment newInstance(long id2, CharSequence title, @StringRes int titleRes, CharSequence description, @StringRes int descriptionRes, @DrawableRes int imageRes, @ColorRes int backgroundRes, @LayoutRes int layout2, int permissionsRequestCode) {
            Bundle arguments = new Bundle();
            arguments.putLong(ARGUMENT_ID, id2);
            arguments.putCharSequence(ARGUMENT_TITLE, title);
            arguments.putInt(ARGUMENT_TITLE_RES, titleRes);
            arguments.putCharSequence(ARGUMENT_DESCRIPTION, description);
            arguments.putInt(ARGUMENT_DESCRIPTION_RES, descriptionRes);
            arguments.putInt(ARGUMENT_IMAGE_RES, imageRes);
            arguments.putInt(ARGUMENT_BACKGROUND_RES, backgroundRes);
            arguments.putInt(ARGUMENT_LAYOUT_RES, layout2);
            arguments.putInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, permissionsRequestCode);
            SimpleSlideFragment fragment = new SimpleSlideFragment();
            fragment.setArguments(arguments);
            return fragment;
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setRetainInstance(true);
            this.updateNavigation();
        }

        public void onResume() {
            super.onResume();
            this.updateNavigation();
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int textColorSecondary;
            int textColorPrimary;
            Bundle arguments = this.getArguments();
            View fragment = inflater.inflate(arguments.getInt(ARGUMENT_LAYOUT_RES, R.layout.mi_fragment_simple_slide), container, false);
            this.titleView = (TextView)fragment.findViewById(R.id.mi_title);
            this.descriptionView = (TextView)fragment.findViewById(R.id.mi_description);
            this.imageView = (ImageView)fragment.findViewById(R.id.mi_image);
            long id2 = arguments.getLong(ARGUMENT_ID);
            CharSequence title = arguments.getCharSequence(ARGUMENT_TITLE);
            int titleRes = arguments.getInt(ARGUMENT_TITLE_RES);
            CharSequence description = arguments.getCharSequence(ARGUMENT_DESCRIPTION);
            int descriptionRes = arguments.getInt(ARGUMENT_DESCRIPTION_RES);
            int imageRes = arguments.getInt(ARGUMENT_IMAGE_RES);
            int backgroundRes = arguments.getInt(ARGUMENT_BACKGROUND_RES);
            if (this.titleView != null) {
                if (title != null) {
                    this.titleView.setText(title);
                    this.titleView.setVisibility(0);
                } else if (titleRes != 0) {
                    this.titleView.setText(titleRes);
                    this.titleView.setVisibility(0);
                } else {
                    this.titleView.setVisibility(8);
                }
            }
            if (this.descriptionView != null) {
                if (description != null) {
                    this.descriptionView.setText(description);
                    this.descriptionView.setVisibility(0);
                } else if (descriptionRes != 0) {
                    this.descriptionView.setText(descriptionRes);
                    this.descriptionView.setVisibility(0);
                } else {
                    this.descriptionView.setVisibility(8);
                }
            }
            if (this.imageView != null) {
                if (imageRes != 0) {
                    try {
                        this.imageView.setImageResource(imageRes);
                    }
                    catch (OutOfMemoryError oome) {
                        this.imageView.setVisibility(8);
                    }
                    this.imageView.setVisibility(0);
                } else {
                    this.imageView.setVisibility(8);
                }
            }
            if (backgroundRes != 0 && ColorUtils.calculateLuminance((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundRes)) < 0.6) {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_dark);
            } else {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_light);
            }
            if (this.titleView != null) {
                this.titleView.setTextColor(textColorPrimary);
            }
            if (this.descriptionView != null) {
                this.descriptionView.setTextColor(textColorSecondary);
            }
            if (this.getActivity() instanceof SimpleSlideActivity) {
                ((SimpleSlideActivity)this.getActivity()).onSlideViewCreated(this, fragment, id2);
            }
            return fragment;
        }

        public void onDestroyView() {
            if (this.getActivity() instanceof SimpleSlideActivity) {
                long id2 = this.getArguments().getLong(ARGUMENT_ID);
                ((SimpleSlideActivity)this.getActivity()).onSlideDestroyView(this, this.getView(), id2);
            }
            this.titleView = null;
            this.descriptionView = null;
            this.imageView = null;
            super.onDestroyView();
        }

        public TextView getTitleView() {
            return this.titleView;
        }

        public TextView getDescriptionView() {
            return this.descriptionView;
        }

        public ImageView getImageView() {
            return this.imageView;
        }

        public long getSlideId() {
            return this.getArguments().getLong(ARGUMENT_ID);
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            int permissionsRequestCode;
            int n = permissionsRequestCode = this.getArguments() == null ? 34 : this.getArguments().getInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, 34);
            if (requestCode == permissionsRequestCode) {
                this.updateNavigation();
            }
        }
    }

    public static class Builder {
        @ColorRes
        private int backgroundRes = 0;
        private long id = 0L;
        @ColorRes
        private int backgroundDarkRes = 0;
        private CharSequence title = null;
        @StringRes
        private int titleRes = 0;
        private CharSequence description = null;
        @StringRes
        private int descriptionRes = 0;
        @DrawableRes
        private int imageRes = 0;
        @LayoutRes
        private int layoutRes = R.layout.mi_fragment_simple_slide;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;
        private String[] permissions = null;
        private CharSequence buttonCtaLabel = null;
        @StringRes
        private int buttonCtaLabelRes = 0;
        private View.OnClickListener buttonCtaClickListener = null;
        private int permissionsRequestCode = 34;

        public Builder background(@ColorRes int backgroundRes) {
            this.backgroundRes = backgroundRes;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDarkRes) {
            this.backgroundDarkRes = backgroundDarkRes;
            return this;
        }

        public Builder title(CharSequence title) {
            this.title = title;
            this.titleRes = 0;
            return this;
        }

        public Builder titleHtml(String titleHtml) {
            this.title = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)titleHtml, (int)0) : Html.fromHtml((String)titleHtml);
            this.titleRes = 0;
            return this;
        }

        public Builder id(long id2) {
            this.id = id2;
            return this;
        }

        public Builder title(@StringRes int titleRes) {
            this.titleRes = titleRes;
            this.title = null;
            return this;
        }

        public Builder description(CharSequence description) {
            this.description = description;
            this.descriptionRes = 0;
            return this;
        }

        public Builder descriptionHtml(String descriptionHtml) {
            this.description = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)descriptionHtml, (int)0) : Html.fromHtml((String)descriptionHtml);
            this.descriptionRes = 0;
            return this;
        }

        public Builder description(@StringRes int descriptionRes) {
            this.descriptionRes = descriptionRes;
            this.description = null;
            return this;
        }

        public Builder image(@DrawableRes int imageRes) {
            this.imageRes = imageRes;
            return this;
        }

        public Builder layout(@LayoutRes int layoutRes) {
            this.layoutRes = layoutRes;
            return this;
        }

        public Builder scrollable(boolean scrollable) {
            this.layoutRes = scrollable ? R.layout.mi_fragment_simple_slide_scrollable : R.layout.mi_fragment_simple_slide;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public Builder permissions(String[] permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permission(String permission) {
            this.permissions = new String[]{permission};
            return this;
        }

        public Builder permissionsRequestCode(int permissionsRequestCode) {
            this.permissionsRequestCode = permissionsRequestCode;
            return this;
        }

        public Builder buttonCtaLabel(CharSequence buttonCtaLabel) {
            this.buttonCtaLabel = buttonCtaLabel;
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabelHtml(String buttonCtaLabelHtml) {
            this.buttonCtaLabel = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)buttonCtaLabelHtml, (int)0) : Html.fromHtml((String)buttonCtaLabelHtml);
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabel(@StringRes int buttonCtaLabelRes) {
            this.buttonCtaLabelRes = buttonCtaLabelRes;
            this.buttonCtaLabel = null;
            return this;
        }

        public Builder buttonCtaClickListener(View.OnClickListener buttonCtaClickListener) {
            this.buttonCtaClickListener = buttonCtaClickListener;
            return this;
        }

        public SimpleSlide build() {
            if (this.backgroundRes == 0) {
                throw new IllegalArgumentException("You must set a background.");
            }
            return new SimpleSlide(this);
        }
    }
}

