/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialintro.view.SwipeBlockableViewPager;

public class FadeableViewPager
extends SwipeBlockableViewPager {
    public FadeableViewPager(Context context) {
        super(context);
    }

    public FadeableViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter((PagerAdapter)new PagerAdapterWrapper(adapter));
    }

    public PagerAdapter getAdapter() {
        return ((PagerAdapterWrapper)super.getAdapter()).getAdapter();
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        super.setOnPageChangeListener((ViewPager.OnPageChangeListener)new OnPageChangeListenerWrapper(listener));
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        super.addOnPageChangeListener((ViewPager.OnPageChangeListener)new OnPageChangeListenerWrapper(listener));
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        super.removeOnPageChangeListener((ViewPager.OnPageChangeListener)new OnPageChangeListenerWrapper(listener));
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        super.setPageTransformer(reverseDrawingOrder, (ViewPager.PageTransformer)new PageTransformerWrapper(transformer, this.getAdapter()));
    }

    public static class SimpleOnOverscrollPageChangeListener
    implements OnOverscrollPageChangeListener {
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    public static interface OnOverscrollPageChangeListener
    extends ViewPager.OnPageChangeListener {
    }

    private class PageTransformerWrapper
    implements ViewPager.PageTransformer {
        private final ViewPager.PageTransformer pageTransformer;
        private final PagerAdapter adapter;

        private PageTransformerWrapper(ViewPager.PageTransformer pageTransformer, PagerAdapter adapter) {
            this.pageTransformer = pageTransformer;
            this.adapter = adapter;
        }

        public void transformPage(View page, float position) {
            this.pageTransformer.transformPage(page, Math.min(position, (float)(this.adapter.getCount() - 1)));
        }
    }

    private class PagerAdapterWrapper
    extends PagerAdapter {
        private final PagerAdapter adapter;

        private PagerAdapterWrapper(PagerAdapter adapter) {
            this.adapter = adapter;
            adapter.registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    PagerAdapterWrapper.this.notifyDataSetChanged();
                }

                public void onInvalidated() {
                    PagerAdapterWrapper.this.notifyDataSetChanged();
                }
            });
        }

        public PagerAdapter getAdapter() {
            return this.adapter;
        }

        public int getCount() {
            return this.adapter.getCount() + 1;
        }

        public boolean isViewFromObject(View view, Object object) {
            return this.adapter.isViewFromObject(view, object);
        }

        public void startUpdate(ViewGroup container) {
            this.adapter.startUpdate(container);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            if (position < this.adapter.getCount()) {
                return this.adapter.instantiateItem(container, position);
            }
            return null;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            if (position < this.adapter.getCount()) {
                this.adapter.destroyItem(container, position, object);
            }
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            if (position < this.adapter.getCount()) {
                this.adapter.setPrimaryItem(container, position, object);
            }
        }

        public void finishUpdate(ViewGroup container) {
            this.adapter.finishUpdate(container);
        }

        @Deprecated
        public void startUpdate(View container) {
            this.adapter.startUpdate(container);
        }

        @Deprecated
        public Object instantiateItem(View container, int position) {
            if (position < this.adapter.getCount()) {
                return this.adapter.instantiateItem(container, position);
            }
            return null;
        }

        @Deprecated
        public void destroyItem(View container, int position, Object object) {
            if (position < this.adapter.getCount()) {
                this.adapter.destroyItem(container, position, object);
            }
        }

        @Deprecated
        public void setPrimaryItem(View container, int position, Object object) {
            if (position < this.adapter.getCount()) {
                this.adapter.setPrimaryItem(container, position, object);
            }
        }

        @Deprecated
        public void finishUpdate(View container) {
            this.adapter.finishUpdate(container);
        }

        public Parcelable saveState() {
            return this.adapter.saveState();
        }

        public void restoreState(Parcelable state, ClassLoader loader) {
            this.adapter.restoreState(state, loader);
        }

        public int getItemPosition(Object object) {
            int position = this.adapter.getItemPosition(object);
            if (position < this.adapter.getCount()) {
                return position;
            }
            return -2;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.adapter.registerDataSetObserver(observer);
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.adapter.unregisterDataSetObserver(observer);
        }

        public CharSequence getPageTitle(int position) {
            if (position < this.adapter.getCount()) {
                return this.adapter.getPageTitle(position);
            }
            return null;
        }

        public float getPageWidth(int position) {
            if (position < this.adapter.getCount()) {
                return this.adapter.getPageWidth(position);
            }
            return 1.0f;
        }
    }

    private class OnPageChangeListenerWrapper
    implements ViewPager.OnPageChangeListener {
        private final ViewPager.OnPageChangeListener listener;

        private OnPageChangeListenerWrapper(ViewPager.OnPageChangeListener listener) {
            this.listener = listener;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int count = this.listener instanceof OnOverscrollPageChangeListener ? FadeableViewPager.super.getAdapter().getCount() : FadeableViewPager.this.getAdapter().getCount();
            this.listener.onPageScrolled(Math.min(position, count), position < count ? positionOffset : 0.0f, position < count ? positionOffsetPixels : 0);
        }

        public void onPageSelected(int position) {
            int count = this.listener instanceof OnOverscrollPageChangeListener ? FadeableViewPager.super.getAdapter().getCount() : FadeableViewPager.this.getAdapter().getCount();
            this.listener.onPageSelected(Math.min(position, count));
        }

        public void onPageScrollStateChanged(int state) {
            this.listener.onPageScrollStateChanged(state);
        }
    }
}

