/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.ViewCompat;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import java.util.ArrayList;

public class SimpleSlide
extends RestorableSlide {
    private static final int DEFAULT_PERMISSIONS_REQUEST_CODE = 34;
    private Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;
    private final boolean canGoForward;
    private final boolean canGoBackward;

    private SimpleSlide(Builder builder) {
        this.fragment = SimpleSlideFragment.newInstance(builder.title, builder.titleRes, builder.description, builder.descriptionRes, builder.imageRes, builder.backgroundRes, builder.backgroundDarkRes, builder.layoutRes, builder.permissions, builder.permissionsRequestCode);
        this.background = builder.backgroundRes;
        this.backgroundDark = builder.backgroundDarkRes;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    @Override
    public boolean canGoForward() {
        if (this.fragment instanceof SlideFragment) {
            return this.canGoForward && ((SlideFragment)this.fragment).canGoForward();
        }
        return this.canGoForward;
    }

    @Override
    public boolean canGoBackward() {
        return this.canGoBackward;
    }

    public static class SimpleSlideFragment
    extends SlideFragment {
        private static final String ARGUMENT_TITLE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE";
        private static final String ARGUMENT_TITLE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE_RES";
        private static final String ARGUMENT_DESCRIPTION = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION";
        private static final String ARGUMENT_DESCRIPTION_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION_RES";
        private static final String ARGUMENT_IMAGE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_IMAGE_RES";
        private static final String ARGUMENT_BACKGROUND_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_RES";
        private static final String ARGUMENT_BACKGROUND_DARK_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_DARK_RES";
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_PERMISSIONS = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_PERMISSIONS";
        private static final String ARGUMENT_PERMISSIONS_REQUEST_CODE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_PERMISSIONS_REQUEST_CODE";
        private Button buttonGrantPermissions;
        private String[] permissions = null;

        public static SimpleSlideFragment newInstance(CharSequence title, @StringRes int titleRes, CharSequence description, @StringRes int descriptionRes, @DrawableRes int imageRes, @ColorRes int background, @ColorRes int backgroundDark, @LayoutRes int layout2, String[] permissions, int permissionsRequestCode) {
            SimpleSlideFragment fragment = new SimpleSlideFragment();
            Bundle arguments = new Bundle();
            arguments.putCharSequence(ARGUMENT_TITLE, title);
            arguments.putInt(ARGUMENT_TITLE_RES, titleRes);
            arguments.putCharSequence(ARGUMENT_DESCRIPTION, description);
            arguments.putInt(ARGUMENT_DESCRIPTION_RES, descriptionRes);
            arguments.putInt(ARGUMENT_IMAGE_RES, imageRes);
            arguments.putInt(ARGUMENT_BACKGROUND_RES, background);
            arguments.putInt(ARGUMENT_BACKGROUND_DARK_RES, backgroundDark);
            arguments.putInt(ARGUMENT_LAYOUT_RES, layout2);
            arguments.putStringArray(ARGUMENT_PERMISSIONS, permissions);
            arguments.putInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, permissionsRequestCode);
            fragment.setArguments(arguments);
            return fragment;
        }

        public void onAttach(Context context) {
            super.onAttach(context);
            Bundle arguments = this.getArguments();
            String[] newPermissions = arguments.getStringArray(ARGUMENT_PERMISSIONS);
            this.updatePermissions(newPermissions != null ? newPermissions : this.permissions);
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setRetainInstance(true);
        }

        public void onResume() {
            super.onResume();
            this.updatePermissions();
            this.updateNavigation();
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int textColorSecondary;
            int textColorPrimary;
            Bundle arguments = this.getArguments();
            View fragment = inflater.inflate(arguments.getInt(ARGUMENT_LAYOUT_RES, R.layout.fragment_simple_slide), container, false);
            TextView titleView = (TextView)fragment.findViewById(R.id.mi_title);
            TextView descriptionView = (TextView)fragment.findViewById(R.id.mi_description);
            this.buttonGrantPermissions = (Button)fragment.findViewById(R.id.mi_button_grant_permissions);
            ImageView imageView = (ImageView)fragment.findViewById(R.id.mi_image);
            CharSequence title = arguments.getCharSequence(ARGUMENT_TITLE);
            int titleRes = arguments.getInt(ARGUMENT_TITLE_RES);
            CharSequence description = arguments.getCharSequence(ARGUMENT_DESCRIPTION);
            int descriptionRes = arguments.getInt(ARGUMENT_DESCRIPTION_RES);
            int imageRes = arguments.getInt(ARGUMENT_IMAGE_RES);
            int backgroundRes = arguments.getInt(ARGUMENT_BACKGROUND_RES);
            int backgroundDarkRes = arguments.getInt(ARGUMENT_BACKGROUND_DARK_RES);
            if (titleView != null) {
                if (title != null) {
                    titleView.setText(title);
                    titleView.setVisibility(0);
                } else if (titleRes != 0) {
                    titleView.setText(titleRes);
                    titleView.setVisibility(0);
                } else {
                    titleView.setVisibility(8);
                }
            }
            if (descriptionView != null) {
                if (description != null) {
                    descriptionView.setText(description);
                    descriptionView.setVisibility(0);
                } else if (descriptionRes != 0) {
                    descriptionView.setText(descriptionRes);
                    descriptionView.setVisibility(0);
                } else {
                    descriptionView.setVisibility(8);
                }
            }
            if (imageView != null) {
                if (imageRes != 0) {
                    imageView.setImageResource(imageRes);
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(8);
                }
            }
            if (backgroundDarkRes != 0 && this.buttonGrantPermissions != null) {
                ViewCompat.setBackgroundTintList((View)this.buttonGrantPermissions, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundDarkRes)));
            }
            if (backgroundRes != 0 && ColorUtils.calculateLuminance((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundRes)) < 0.6) {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_dark);
            } else {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_light);
            }
            if (titleView != null) {
                titleView.setTextColor(textColorPrimary);
            }
            if (descriptionView != null) {
                descriptionView.setTextColor(textColorSecondary);
            }
            if (this.buttonGrantPermissions != null) {
                this.buttonGrantPermissions.setTextColor(textColorPrimary);
            }
            return fragment;
        }

        private void updatePermissions() {
            this.updatePermissions(this.permissions);
        }

        private synchronized void updatePermissions(@Nullable String[] newPermissions) {
            if (newPermissions != null) {
                ArrayList<String> permissionsNotGranted = new ArrayList<String>();
                for (String permission : newPermissions) {
                    if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission) == 0) continue;
                    permissionsNotGranted.add(permission);
                }
                if (permissionsNotGranted.size() > 0) {
                    this.permissions = permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]);
                    if (this.buttonGrantPermissions != null) {
                        this.buttonGrantPermissions.setVisibility(0);
                        this.buttonGrantPermissions.setText(this.getResources().getQuantityText(R.plurals.mi_label_grant_permission, permissionsNotGranted.size()));
                        this.buttonGrantPermissions.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                int permissionsRequestCode = SimpleSlideFragment.this.getArguments() == null ? 34 : SimpleSlideFragment.this.getArguments().getInt(SimpleSlideFragment.ARGUMENT_PERMISSIONS_REQUEST_CODE, 34);
                                ActivityCompat.requestPermissions((Activity)SimpleSlideFragment.this.getActivity(), (String[])SimpleSlideFragment.this.permissions, (int)permissionsRequestCode);
                            }
                        });
                    }
                } else {
                    this.permissions = null;
                    if (this.buttonGrantPermissions != null) {
                        this.buttonGrantPermissions.setVisibility(8);
                    }
                }
            } else {
                this.permissions = null;
                if (this.buttonGrantPermissions != null) {
                    this.buttonGrantPermissions.setVisibility(8);
                }
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            int permissionsRequestCode;
            int n = permissionsRequestCode = this.getArguments() == null ? 34 : this.getArguments().getInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, 34);
            if (requestCode == permissionsRequestCode) {
                this.updatePermissions();
                this.updateNavigation();
            }
        }

        @Override
        public synchronized boolean canGoForward() {
            ArrayList<String> permissionsNotGranted = new ArrayList<String>();
            if (this.permissions != null) {
                for (String permission : this.permissions) {
                    if (this.getActivity() != null && ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission) == 0) continue;
                    permissionsNotGranted.add(permission);
                }
            }
            return permissionsNotGranted.size() <= 0;
        }
    }

    public static class Builder {
        @ColorRes
        private int backgroundRes = 0;
        @ColorRes
        private int backgroundDarkRes = 0;
        private CharSequence title = null;
        @StringRes
        private int titleRes = 0;
        private CharSequence description = null;
        @StringRes
        private int descriptionRes = 0;
        @DrawableRes
        private int imageRes = 0;
        @LayoutRes
        private int layoutRes = R.layout.fragment_simple_slide;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;
        private String[] permissions = null;
        private int permissionsRequestCode = 34;

        public Builder background(@ColorRes int backgroundRes) {
            this.backgroundRes = backgroundRes;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDarkRes) {
            this.backgroundDarkRes = backgroundDarkRes;
            return this;
        }

        public Builder title(CharSequence title) {
            this.title = title;
            this.titleRes = 0;
            return this;
        }

        public Builder titleHtml(String titleHtml) {
            this.title = Html.fromHtml((String)titleHtml);
            this.titleRes = 0;
            return this;
        }

        public Builder title(@StringRes int titleRes) {
            this.titleRes = titleRes;
            this.title = null;
            return this;
        }

        public Builder description(CharSequence description) {
            this.description = description;
            this.descriptionRes = 0;
            return this;
        }

        public Builder descriptionHtml(String descriptionHtml) {
            this.description = Html.fromHtml((String)descriptionHtml);
            this.descriptionRes = 0;
            return this;
        }

        public Builder description(@StringRes int descriptionRes) {
            this.descriptionRes = descriptionRes;
            this.description = null;
            return this;
        }

        public Builder image(@DrawableRes int imageRes) {
            this.imageRes = imageRes;
            return this;
        }

        public Builder layout(@LayoutRes int layoutRes) {
            this.layoutRes = layoutRes;
            return this;
        }

        public Builder scrollable(boolean scrollable) {
            this.layoutRes = scrollable ? R.layout.fragment_simple_slide_scrollable : R.layout.fragment_simple_slide;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public Builder permissions(String[] permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permission(String permission) {
            this.permissions = new String[]{permission};
            return this;
        }

        public Builder permissionsRequestCode(int permissionsRequestCode) {
            this.permissionsRequestCode = permissionsRequestCode;
            return this;
        }

        public SimpleSlide build() {
            return new SimpleSlide(this);
        }
    }
}

