/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.xml;

import com.heaven7.java.base.util.Predicates;
import com.heaven7.java.reflecty.utils.Pair;
import com.heaven7.java.xml.Tree;
import com.heaven7.java.xml.XmlReaderImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class XmlTree
implements Tree {
    static final String NAME_BODY = XmlTree.class.getName() + "_@body@";
    List<XmlTree> children = new ArrayList<XmlTree>();
    XmlTree parent;
    int childIndex = -1;
    XmlReaderImpl.Element element;
    int attibuteIndex = -1;
    final List<Attribute> attrList;
    boolean attributeEnd;
    String bodyText;

    public XmlTree(XmlReaderImpl.Element element) {
        this.element = element;
        if (element.getAttributes() != null) {
            this.attrList = new ArrayList<Attribute>();
            for (Map.Entry<String, String> en : element.getAttributes().entrySet()) {
                this.attrList.add(new Attribute(this, en.getKey(), en.getValue()));
            }
        } else {
            this.attrList = null;
        }
        this.bodyText = element.getText();
    }

    public void reset() {
        this.bodyText = this.element.getText();
        this.attributeEnd = false;
        this.attibuteIndex = -1;
        this.childIndex = -1;
        for (XmlTree tree : this.children) {
            tree.reset();
        }
    }

    public void addChild(XmlTree gl) {
        this.children.add(gl);
        gl.parent = this;
    }

    @Override
    public boolean hasNextChild() {
        if (Predicates.isEmpty(this.attrList) || this.attributeEnd) {
            if (this.children.size() > this.childIndex + 1) {
                return true;
            }
            return this.bodyText != null;
        }
        return this.attrList.size() > this.attibuteIndex + 1;
    }

    @Override
    public Tree nextChild() {
        if (Predicates.isEmpty(this.attrList) || this.attributeEnd) {
            ++this.childIndex;
            if (this.children.size() > this.childIndex) {
                return this.children.get(this.childIndex);
            }
        } else {
            ++this.attibuteIndex;
            boolean bl = this.attributeEnd = this.attibuteIndex == this.attrList.size() - 1;
            if (this.attrList.size() > this.attibuteIndex) {
                return this.attrList.get(this.attibuteIndex);
            }
        }
        if (this.bodyText != null) {
            StringTree tree = new StringTree(this, NAME_BODY, this.bodyText);
            this.bodyText = null;
            return tree;
        }
        return null;
    }

    @Override
    public Tree getParent() {
        return this.parent;
    }

    @Override
    public String getBodyText() throws IOException {
        return this.element.getText();
    }

    @Override
    public String getName() throws IOException {
        return this.element.getName();
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }

    static class StringTree
    extends Pair<String, String>
    implements Tree {
        final Tree parent;

        public StringTree(Tree parent, String name, String value) {
            super((Object)name, (Object)value);
            this.parent = parent;
        }

        @Override
        public boolean hasNextChild() {
            return false;
        }

        @Override
        public Tree nextChild() {
            return null;
        }

        @Override
        public Tree getParent() {
            return this.parent;
        }

        @Override
        public String getBodyText() throws IOException {
            if (this.key == null) {
                throw new UnsupportedOperationException();
            }
            return (String)this.value;
        }

        @Override
        public String getName() throws IOException {
            if (this.key == null) {
                throw new UnsupportedOperationException();
            }
            return (String)this.key;
        }

        @Override
        public String getValue() {
            return (String)this.value;
        }
    }

    static class Attribute
    extends Pair<String, String>
    implements Tree {
        final XmlTree parent;
        final List<StringTree> list = new ArrayList<StringTree>();
        int index = -1;

        public Attribute(XmlTree parent, String key, String value) {
            super((Object)key, (Object)value);
            this.parent = parent;
            for (String str : value.split(",")) {
                this.list.add(new StringTree(this, null, str));
            }
        }

        @Override
        public boolean hasNextChild() {
            return this.list.size() > this.index + 1;
        }

        @Override
        public Tree nextChild() {
            if (this.list.size() > this.index + 1) {
                return this.list.get(++this.index);
            }
            return null;
        }

        @Override
        public Tree getParent() {
            return this.parent;
        }

        @Override
        public String getBodyText() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() throws IOException {
            return (String)this.key;
        }

        @Override
        public String getValue() {
            return (String)this.value;
        }
    }
}

