/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio.plugin;

import com.heaven7.java.base.util.SparseArrayDelegate;
import com.heaven7.java.base.util.SparseFactory;
import com.heaven7.java.reflectyio.plugin.ReflectyPlugin;

public final class ReflectyPluginManager {
    private final SparseArrayDelegate<ReflectyPlugin> mPluginMap = SparseFactory.newSparseArray((int)5);

    private ReflectyPluginManager() {
    }

    public static ReflectyPluginManager getDefault() {
        return Creator.INSTANCE;
    }

    public void registerReflectyPlugin(int type, ReflectyPlugin plugin) {
        this.mPluginMap.put(type, (Object)plugin);
    }

    public void unregisterReflectyPlugin(int type) {
        this.mPluginMap.getAndRemove(type);
    }

    public ReflectyPlugin getReflectyPlugin(int type) {
        return (ReflectyPlugin)this.mPluginMap.get(type);
    }

    static {
        int[] types = new int[]{1, 2, 3};
        String[] names = new String[]{"com.heaven7.java.reflectyio.plugin.XmlReflectyPlugin", "com.heaven7.java.reflectyio.plugin.YamlReflectyPlugin", "com.heaven7.java.reflectyio.plugin.JsonReflectyPlugin"};
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            try {
                ReflectyPlugin rp = (ReflectyPlugin)Class.forName(names[i]).newInstance();
                ReflectyPluginManager.getDefault().registerReflectyPlugin(types[i], rp);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Creator {
        static final ReflectyPluginManager INSTANCE = new ReflectyPluginManager();

        private Creator() {
        }
    }
}

