/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio.adapter;

import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflecty.Wrapper;
import com.heaven7.java.reflecty.iota.BasicTypeAdapter;
import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.adapter.AbstractTypeAdapter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public final class MapTypeAdapter
extends AbstractTypeAdapter {
    private final ReflectyContext mContext;
    private final Class<?> mMapClass;
    private final TypeAdapter<ReflectyWriter, ReflectyReader> mKeyAdapter;
    private final TypeAdapter<ReflectyWriter, ReflectyReader> mValueAdapter;

    public MapTypeAdapter(ReflectyEvaluator evaluator, ReflectyContext mContext, Class<?> mMapClass, TypeAdapter<ReflectyWriter, ReflectyReader> mKeyAdapter, TypeAdapter<ReflectyWriter, ReflectyReader> mValueAdapter) {
        super(evaluator);
        this.mContext = mContext;
        this.mMapClass = mMapClass;
        this.mKeyAdapter = mKeyAdapter;
        this.mValueAdapter = mValueAdapter;
    }

    public int write(ReflectyWriter sink, Object obj) throws IOException {
        if (obj == null) {
            sink.beginObject(this.mContext, this.mMapClass);
            sink.endObject();
            return 0;
        }
        Map map = this.mContext.getMap(obj);
        if (this.mKeyAdapter instanceof BasicTypeAdapter) {
            TypeAdapter key = ((BasicTypeAdapter)this.mKeyAdapter).getNameTypeAdapter();
            Set set = map.entrySet();
            sink.beginObject(this.mContext, this.mMapClass);
            for (Map.Entry en : set) {
                key.write((Object)sink, en.getKey());
                this.mValueAdapter.write((Object)sink, en.getValue());
            }
            sink.endObject();
        } else {
            TypeAdapter<ReflectyWriter, ReflectyReader> key = this.mKeyAdapter;
            Set set = map.entrySet();
            sink.beginArray();
            for (Map.Entry en : set) {
                key.write((Object)sink, en.getKey());
                this.mValueAdapter.write((Object)sink, en.getValue());
            }
            sink.endArray();
        }
        return 0;
    }

    public Object read(ReflectyReader source) throws IOException {
        Map map = this.mContext.createMap(this.mMapClass);
        if (this.mKeyAdapter instanceof BasicTypeAdapter) {
            TypeAdapter keyTA = ((BasicTypeAdapter)this.mKeyAdapter).getNameTypeAdapter();
            source.beginObject(this.mContext, this.mMapClass);
            while (source.hasNext()) {
                Object key = keyTA.read((Object)source);
                Object value = this.mValueAdapter.read((Object)source);
                map.put(key, value);
            }
            source.endObject();
        } else {
            TypeAdapter<ReflectyWriter, ReflectyReader> keyTA = this.mKeyAdapter;
            source.beginArray();
            while (source.hasNext()) {
                Object key = keyTA.read((Object)source);
                Object value = this.mValueAdapter.read((Object)source);
                map.put(key, value);
            }
            source.endArray();
        }
        return map instanceof Wrapper ? ((Wrapper)map).unwrap() : map;
    }
}

