/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio;

import com.heaven7.java.base.anno.NonNull;
import com.heaven7.java.base.util.Throwables;
import com.heaven7.java.reflecty.Reflecty;
import com.heaven7.java.reflecty.ReflectyBuilder;
import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflecty.ReflectyDelegate;
import com.heaven7.java.reflecty.SimpleReflectyContext;
import com.heaven7.java.reflecty.iota.AbstractTypeAdapterManager;
import com.heaven7.java.reflecty.iota.ITypeAdapterManager;
import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.SimpleReflectyDelegate;
import com.heaven7.java.reflectyio.SimpleReflectyEvaluator;
import com.heaven7.java.reflectyio.adapter.ArrayTypeAdapter;
import com.heaven7.java.reflectyio.adapter.CharAdapter;
import com.heaven7.java.reflectyio.adapter.CollectionTypeAdapter;
import com.heaven7.java.reflectyio.adapter.CommonTypeAdapter;
import com.heaven7.java.reflectyio.adapter.MapTypeAdapter;
import com.heaven7.java.reflectyio.adapter.ObjectTypeAdapter;
import com.heaven7.java.reflectyio.adapter.StringAdapter;
import com.heaven7.java.reflectyio.anno.ReflectyClass;
import com.heaven7.java.reflectyio.anno.ReflectyField;
import com.heaven7.java.reflectyio.anno.ReflectyInherit;
import com.heaven7.java.reflectyio.anno.ReflectyMethod;

public class ReflectyTypeAdapterManager
extends AbstractTypeAdapterManager<ReflectyWriter, ReflectyReader> {
    private final Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> mReflecty;
    private final ReflectyEvaluator mEvaluator;

    public ReflectyTypeAdapterManager() {
        this((Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit>)new ReflectyBuilder().classAnnotation(ReflectyClass.class).fieldAnnotation(ReflectyField.class).methodAnnotation(ReflectyMethod.class).inheritAnnotation(ReflectyInherit.class).delegate((ReflectyDelegate)new SimpleReflectyDelegate()).build());
    }

    public ReflectyTypeAdapterManager(Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> mReflecty) {
        this((ReflectyContext)new SimpleReflectyContext(), SimpleReflectyEvaluator.INSTANCE, mReflecty);
    }

    public ReflectyTypeAdapterManager(@NonNull ReflectyContext context, @NonNull ReflectyEvaluator evaluator, @NonNull Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> mReflecty) {
        super(context);
        Throwables.checkNull((Object)context);
        Throwables.checkNull((Object)evaluator);
        Throwables.checkNull(mReflecty);
        this.mEvaluator = evaluator;
        this.mReflecty = mReflecty;
        this.registerCore();
    }

    private void registerCore() {
        this.registerAdapters(Byte.TYPE, Byte.class);
        this.registerAdapters(Short.TYPE, Short.class);
        this.registerAdapters(Integer.TYPE, Integer.class);
        this.registerAdapters(Long.TYPE, Long.class);
        this.registerAdapters(Float.TYPE, Float.class);
        this.registerAdapters(Double.TYPE, Double.class);
        this.registerAdapters(Boolean.TYPE, Boolean.class);
        CharAdapter ca = new CharAdapter(this.mEvaluator);
        this.registerBasicTypeAdapter(Character.TYPE, (TypeAdapter)ca);
        this.registerBasicTypeAdapter(Character.class, (TypeAdapter)ca);
        this.registerBasicTypeAdapter(String.class, (TypeAdapter)new StringAdapter(this.mEvaluator));
    }

    private <T> void registerAdapters(Class<?> base, Class<T> wrap) {
        CommonTypeAdapter<T> byteAdapter = new CommonTypeAdapter<T>(this.mEvaluator, wrap);
        this.registerBasicTypeAdapter(base, (TypeAdapter)byteAdapter);
        this.registerBasicTypeAdapter(wrap, (TypeAdapter)byteAdapter);
    }

    public Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> getReflecty() {
        return this.mReflecty;
    }

    public ReflectyEvaluator getReflectyEvaluator() {
        return this.mEvaluator;
    }

    public TypeAdapter<ReflectyWriter, ReflectyReader> createCollectionTypeAdapter(Class<?> collectionClass, TypeAdapter<ReflectyWriter, ReflectyReader> componentAdapter) {
        return new CollectionTypeAdapter(this.mEvaluator, this.getReflectyContext(), collectionClass, componentAdapter);
    }

    public TypeAdapter<ReflectyWriter, ReflectyReader> createArrayTypeAdapter(Class<?> componentClass, TypeAdapter<ReflectyWriter, ReflectyReader> componentAdapter) {
        return new ArrayTypeAdapter(this.mEvaluator, componentClass, componentAdapter);
    }

    public TypeAdapter<ReflectyWriter, ReflectyReader> createMapTypeAdapter(Class<?> mapClazz, TypeAdapter<ReflectyWriter, ReflectyReader> keyAdapter, TypeAdapter<ReflectyWriter, ReflectyReader> valueAdapter) {
        return new MapTypeAdapter(this.mEvaluator, this.getReflectyContext(), mapClazz, keyAdapter, valueAdapter);
    }

    public TypeAdapter<ReflectyWriter, ReflectyReader> createObjectTypeAdapter(Class<?> objectClazz, float applyVersion) {
        return new ObjectTypeAdapter(this.mEvaluator, this.mReflecty, (ITypeAdapterManager<ReflectyWriter, ReflectyReader>)this, objectClazz, applyVersion);
    }
}

