/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflecty;

import com.heaven7.java.reflecty.MemberProxy;
import com.heaven7.java.reflecty.ReflectyBuilder;
import com.heaven7.java.reflecty.ReflectyDelegate;
import com.heaven7.java.reflecty.member.FieldProxy;
import com.heaven7.java.reflecty.member.MethodProxy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public final class Reflecty<PR, CD extends Annotation, F extends Annotation, M extends Annotation, I extends Annotation> {
    private final WeakHashMap<Class<?>, List<MemberProxy>> mCache;
    private final WeakHashMap<Class<?>, List<MemberProxy>> mShareCache;
    private final ReflectyDelegate<PR, CD, F, M, I> mDelegate;
    private final Class<CD> mClazzClass;
    private final Class<F> mClazzField;
    private final Class<M> mClazzMethod;
    private final Class<I> mClazzIherit;

    Reflecty(ReflectyBuilder<PR, CD, F, M, I> builder) {
        this.mDelegate = builder.mDelegate;
        this.mClazzClass = builder.clazzObject;
        this.mClazzField = builder.clazzField;
        this.mClazzMethod = builder.clazzMethod;
        this.mClazzIherit = builder.clazzInherit;
        this.mCache = new WeakHashMap();
        this.mShareCache = new WeakHashMap();
    }

    public void initializeMembers(List<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.getMemberProxies(clazz);
        }
    }

    public List<MemberProxy> getMemberProxies(Class<?> clazz) {
        List<MemberProxy> memberProxies = this.mCache.get(clazz);
        if (memberProxies == null) {
            memberProxies = this.getMemberProxies1(clazz);
            this.mCache.put(clazz, memberProxies);
        }
        return memberProxies;
    }

    public PR performReflectClass(Class<?> clazz) {
        return this.mDelegate.performReflectClass(clazz);
    }

    private List<MemberProxy> getMemberProxies1(Class<?> clazz) {
        ArrayList<MemberProxy> out = new ArrayList<MemberProxy>();
        this.getMemberProxies0(clazz, out);
        this.mDelegate.sort(out);
        return out;
    }

    private void getMemberProxies0(Class<?> clazz, List<MemberProxy> out) {
        Class<?> rawClass = clazz;
        while (clazz != Object.class) {
            List<MemberProxy> proxies;
            boolean isInherit;
            boolean bl = isInherit = clazz != rawClass;
            if (isInherit && (proxies = this.mShareCache.get(clazz)) != null) {
                out.addAll(0, proxies);
                if ((clazz = clazz.getSuperclass()) != null) continue;
                break;
            }
            ArrayList<MemberProxy> allowInherits = new ArrayList<MemberProxy>();
            Field[] fields = clazz.getDeclaredFields();
            CD clazzClass = null;
            if (this.mClazzClass != null && (clazzClass = (CD)clazz.getAnnotation(this.mClazzClass)) == null && this.mDelegate.isAllowInherit(this.mClazzClass)) {
                Object superClass = clazz.getSuperclass();
                do {
                    clazzClass = ((Class)superClass).getAnnotation(this.mClazzClass);
                } while ((superClass = ((Class)superClass).getSuperclass()) != Object.class && superClass != null && clazzClass == null);
            }
            for (Field f : fields) {
                Object inherit;
                f.setAccessible(true);
                F fieldDesc = f.getAnnotation(this.mClazzField);
                if (!this.mDelegate.shouldIncludeField(f, fieldDesc, isInherit)) continue;
                FieldProxy proxy = this.mDelegate.createFieldProxy(clazz, clazzClass, f, this.mDelegate.getPropertyFromField(f, fieldDesc), fieldDesc);
                out.add(proxy);
                Object i = inherit = this.mClazzIherit != null ? (Object)f.getAnnotation(this.mClazzIherit) : null;
                if (!this.mDelegate.isAllowInherit(inherit)) continue;
                allowInherits.add(proxy);
            }
            if (this.mClazzMethod != null) {
                Method[] methods;
                ArrayList<Method> gets = new ArrayList<Method>();
                ArrayList<Method> sets = new ArrayList<Method>();
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    method.setAccessible(true);
                    M mm = method.getAnnotation(this.mClazzMethod);
                    if (!this.mDelegate.shouldIncludeMethod(method, mm, isInherit)) continue;
                    if (this.mDelegate.isGetMethod(method, mm)) {
                        if (method.getParameterTypes().length > 0) {
                            throw new IllegalStateException("as 'get' method for @MethodMember must have no arguments.");
                        }
                        if (isInherit) {
                            Object inherit;
                            Object i = inherit = this.mClazzIherit != null ? (Object)method.getAnnotation(this.mClazzIherit) : null;
                            if (!this.mDelegate.isAllowInherit(inherit)) continue;
                        }
                        gets.add(method);
                        continue;
                    }
                    if (method.getParameterTypes().length != 1) {
                        throw new IllegalStateException("as 'set' method for @MethodMember can only have one argument.");
                    }
                    sets.add(method);
                }
                if (!gets.isEmpty() || !sets.isEmpty()) {
                    if (gets.size() >= sets.size()) {
                        this.makePairMethods(clazz, clazzClass, gets, sets, true, out, allowInherits);
                    } else {
                        this.makePairMethods(clazz, clazzClass, sets, gets, false, out, allowInherits);
                    }
                }
            }
            this.mShareCache.put(clazz, allowInherits);
            if ((clazz = clazz.getSuperclass()) != null) continue;
            break;
        }
    }

    private void makePairMethods(Class<?> owner, CD classDesc, List<Method> src, List<Method> others, boolean srcIsGet, List<MemberProxy> out, List<MemberProxy> shareOut) {
        int bigSize = src.size();
        for (int i = 0; i < bigSize; ++i) {
            Method main;
            MethodProxy proxy;
            Method method = src.get(i);
            M mn = method.getAnnotation(this.mClazzMethod);
            String property = this.mDelegate.getPropertyFromMethod(method, mn);
            Method other = null;
            for (Method m2 : others) {
                if (!this.mDelegate.getPropertyFromMethod(m2, m2.getAnnotation(this.mClazzMethod)).equals(property)) continue;
                other = m2;
                break;
            }
            if (other == null) {
                System.out.println("MessageProtocal: can't make-pair for method. " + method.toString());
                continue;
            }
            if (srcIsGet) {
                proxy = this.mDelegate.createMethodProxy(owner, classDesc, method, other, property, mn);
                main = method;
            } else {
                proxy = this.mDelegate.createMethodProxy(owner, classDesc, other, method, property, mn);
                main = other;
            }
            out.add(proxy);
            I inherit = main.getAnnotation(this.mClazzIherit);
            if (!this.mDelegate.isAllowInherit(inherit)) continue;
            shareOut.add(proxy);
        }
    }
}

