/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflecty;

import com.heaven7.java.base.util.Predicates;
import com.heaven7.java.reflecty.TypeNode;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;

public final class $ReflectyTypes {
    private static WeakHashMap<Class<?>, List<TypeVariablePair>> sTypeVars = new WeakHashMap();

    public static TypeNode getTypeNode(Type type) {
        GenericNode node = new GenericNode();
        $ReflectyTypes.parseNode(null, type, node);
        return node;
    }

    public static TypeNode getTypeNode(Class ownerClass, Type type) {
        GenericNode node = new GenericNode();
        $ReflectyTypes.parseNode(ownerClass, type, node);
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseNode(Class ownerClass, Type type, GenericNode parent) {
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList<TypeNode> subs = new ArrayList<TypeNode>();
            for (Type t : types) {
                GenericNode node = new GenericNode();
                $ReflectyTypes.parseNode(ownerClass, t, node);
                subs.add(node);
            }
            parent.type = (Class)((ParameterizedType)type).getRawType();
            parent.subType = subs;
            return;
        } else if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            parent.isArray = true;
            GenericNode node = new GenericNode();
            $ReflectyTypes.parseNode(ownerClass, componentType, node);
            parent.addNode(node);
            return;
        } else if (type instanceof WildcardType) {
            Object[] lowerBounds = ((WildcardType)type).getLowerBounds();
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (Predicates.isEmpty((Object[])lowerBounds)) {
                $ReflectyTypes.parseNode(ownerClass, upperBounds[0], parent);
                return;
            } else {
                $ReflectyTypes.parseNode(ownerClass, (Type)lowerBounds[0], parent);
            }
            return;
        } else if (type instanceof TypeVariable) {
            TypeVariablePair pair;
            String name = ((TypeVariable)type).getName();
            if (sTypeVars.get(ownerClass) == null) {
                ParameterizedType pt = (ParameterizedType)ownerClass.getGenericSuperclass();
                if (pt == null) {
                    throw new UnsupportedOperationException("must extend the generic super class");
                }
                TypeVariable<?>[] types = ((TypeVariable)type).getGenericDeclaration().getTypeParameters();
                ArrayList<TypeVariablePair> pairs = new ArrayList<TypeVariablePair>();
                Type[] tts = pt.getActualTypeArguments();
                int size = tts.length;
                for (int i = 0; i < size; ++i) {
                    GenericNode node = new GenericNode();
                    $ReflectyTypes.parseNode(ownerClass, tts[i], node);
                    pairs.add(new TypeVariablePair(types[i].getName(), node));
                }
                sTypeVars.put(ownerClass, pairs);
            }
            if ((pair = $ReflectyTypes.getTypeVariablePair(ownerClass, name)) == null) throw new UnsupportedOperationException("can't find TypeVariablePair for " + name + " ,from class " + ownerClass.getName());
            parent.addVariableNode(pair.node);
            return;
        } else {
            if (!(type instanceof Class)) throw new RuntimeException("" + type);
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                parent.isArray = true;
                GenericNode node = new GenericNode();
                $ReflectyTypes.parseNode(ownerClass, clazz.getComponentType(), node);
                parent.addNode(node);
                return;
            } else {
                parent.type = clazz;
            }
        }
    }

    private static TypeVariablePair getTypeVariablePair(Class<?> clazz, String declareName) {
        List<TypeVariablePair> pairs = sTypeVars.get(clazz);
        if (Predicates.isEmpty(pairs)) {
            return null;
        }
        for (TypeVariablePair pair : pairs) {
            if (!pair.declareName.equals(declareName)) continue;
            return pair;
        }
        return null;
    }

    private static class TypeVariablePair {
        public final String declareName;
        public final GenericNode node;

        public TypeVariablePair(String declareName, GenericNode node) {
            this.declareName = declareName;
            this.node = node;
        }
    }

    private static class GenericNode
    implements TypeNode {
        public Class<?> type;
        public List<TypeNode> varNodes;
        public List<TypeNode> subType;
        public boolean isArray;

        private GenericNode() {
        }

        public void addNode(GenericNode node) {
            if (this.subType == null) {
                this.subType = new ArrayList<TypeNode>();
            }
            this.subType.add(node);
        }

        public void addVariableNode(GenericNode varNode) {
            if (this.varNodes == null) {
                this.varNodes = new ArrayList<TypeNode>();
            }
            this.varNodes.add(varNode);
        }

        @Override
        public Class<?> getRawClass() {
            return this.type;
        }

        @Override
        public boolean isArray() {
            return this.isArray;
        }

        @Override
        public List<TypeNode> getVariableNodes() {
            return this.varNodes;
        }

        @Override
        public Class<?> getTypeClass(int index) {
            if (this.type != null) {
                return this.type;
            }
            if (this.isArray) {
                return Array.newInstance(this.subType.get(0).getTypeClass(0), 0).getClass();
            }
            return this.varNodes.get(index).getTypeClass(0);
        }

        @Override
        public TypeNode getSubNode(int index) {
            if (Predicates.isEmpty(this.subType)) {
                if (!Predicates.isEmpty(this.varNodes)) {
                    return this.varNodes.get(index);
                }
                return null;
            }
            return this.subType.get(index);
        }

        @Override
        public int getSubNodeCount() {
            if (Predicates.isEmpty(this.subType)) {
                if (!Predicates.isEmpty(this.varNodes)) {
                    return this.varNodes.size();
                }
                return 0;
            }
            return this.subType.size();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericNode node = (GenericNode)o;
            return this.isArray == node.isArray && Objects.equals(this.type, node.type) && Objects.equals(this.varNodes, node.varNodes) && Objects.equals(this.subType, node.subType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type, this.varNodes, this.subType, this.isArray);
        }
    }
}

