/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util.threadpool;

import com.heaven7.java.base.util.Throwables;
import com.heaven7.java.base.util.threadpool.ThreadPoolExecutor2;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ScheduledThreadPoolExecutor2
extends ScheduledThreadPoolExecutor {
    private boolean exceptionStrictly;

    public ScheduledThreadPoolExecutor2(int corePoolSize) {
        super(corePoolSize);
    }

    public ScheduledThreadPoolExecutor2(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public ScheduledThreadPoolExecutor2(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public ScheduledThreadPoolExecutor2(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public boolean isExceptionStrictly() {
        return this.exceptionStrictly;
    }

    public void setExceptionStrictly(boolean exceptionStrictly) {
        this.exceptionStrictly = exceptionStrictly;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Throwables.handleExceptionSmartly(t, this.exceptionStrictly);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ThreadPoolExecutor2.FutureTask2<T>(callable, this.exceptionStrictly);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ThreadPoolExecutor2.FutureTask2<T>(runnable, value, this.exceptionStrictly);
    }

    public static class Builder {
        private int corePoolSize;
        private ThreadFactory threadFactory;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private boolean exceptionStrictly;

        public Builder setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public Builder setExceptionStrictly(boolean exceptionStrictly) {
            this.exceptionStrictly = exceptionStrictly;
            return this;
        }

        public ScheduledThreadPoolExecutor build() {
            ScheduledThreadPoolExecutor2 instance = this.rejectedExecutionHandler == null ? (this.threadFactory != null ? new ScheduledThreadPoolExecutor2(this.corePoolSize, this.threadFactory) : new ScheduledThreadPoolExecutor2(this.corePoolSize)) : (this.threadFactory == null ? new ScheduledThreadPoolExecutor2(this.corePoolSize, this.rejectedExecutionHandler) : new ScheduledThreadPoolExecutor2(this.corePoolSize, this.threadFactory, this.rejectedExecutionHandler));
            instance.setExceptionStrictly(this.exceptionStrictly);
            return instance;
        }
    }
}

