/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.Disposable;
import java.util.concurrent.ThreadFactory;

public abstract class ThreadProxy
implements Disposable {
    public abstract void start(Runnable var1);

    public static ThreadProxy create(ThreadFactory factory) {
        return new ThreadProxyImpl(factory);
    }

    private static class ThreadProxyImpl
    extends ThreadProxy {
        private final ThreadFactory mFactory;
        private volatile Thread mThread;

        public ThreadProxyImpl(ThreadFactory factory) {
            this.mFactory = factory;
        }

        @Override
        public void start(Runnable runnable) {
            if (this.mThread == null) {
                this.mThread = this.mFactory.newThread(runnable);
                this.mThread.start();
            }
        }

        @Override
        public void dispose() {
            if (this.mThread != null) {
                this.mThread.interrupt();
                this.mThread = null;
            }
        }
    }
}

