/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.Nullable;
import com.heaven7.java.base.util.Platforms;

public class TextUtils {
    private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String getRelativePathForPrefix(String absPath, String prefixPath) {
        int index = absPath.indexOf(prefixPath);
        if (index == -1) {
            throw new IllegalArgumentException("can't getRelativePath for absPath = " + absPath + " ,prefixPath = " + prefixPath);
        }
        String result = absPath.substring(index + prefixPath.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        } else if (result.startsWith("\\")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String getRelativePathForSuffix(String absPath, String suffixPath) {
        int index = absPath.indexOf(suffixPath);
        if (index == -1) {
            throw new IllegalArgumentException("can't getRelativePath for absPath = " + absPath + " ,subPath = " + suffixPath);
        }
        String result = absPath.substring(index);
        if (result.startsWith("/")) {
            result = result.substring(1);
        } else if (result.startsWith("\\")) {
            result = result.substring(1);
        }
        return result;
    }

    public static boolean isRelativePath(String path) {
        if (path.startsWith("/")) {
            return false;
        }
        if (Platforms.isWindows()) {
            for (char ch : ALPHABET) {
                if (!path.startsWith(ch + ":")) continue;
                return false;
            }
        }
        return true;
    }
}

