/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.Throwables;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class SmartReference<T> {
    private WeakReference<T> mWeakRef;
    private T mT;

    public SmartReference(T t) {
        Throwables.checkNull(t);
        if (t instanceof Reference) {
            throw new UnsupportedOperationException("the object can't be any other Reference(WeakReference, SoftReference and etc.)");
        }
        if (this.shouldWeakReference(t)) {
            this.mWeakRef = new WeakReference<T>(t);
        } else {
            this.mT = t;
        }
    }

    public final T get() {
        Object t = this.mT == null ? (this.mWeakRef != null ? this.mWeakRef.get() : null) : this.mT;
        if (t != null && this.shouldDestroyReference(t)) {
            this.mWeakRef = null;
            this.mT = null;
            return null;
        }
        return t;
    }

    public final boolean isAlive() {
        return this.isStrongAlive() || this.isWeakAlive();
    }

    public final boolean isWeakAlive() {
        return this.mWeakRef != null && this.mWeakRef.get() != null;
    }

    public final boolean isStrongAlive() {
        return this.mT != null;
    }

    public boolean tryStrongReference() {
        if (this.mT == null && this.mWeakRef != null) {
            Object t = this.mWeakRef.get();
            if (t == null) {
                return false;
            }
            this.mT = t;
            this.mWeakRef = null;
            return true;
        }
        return false;
    }

    public boolean tryWeakReference() {
        if (this.mT != null) {
            this.mWeakRef = new WeakReference<T>(this.mT);
            this.mT = null;
            return true;
        }
        return false;
    }

    protected boolean shouldWeakReference(T t) {
        return false;
    }

    protected boolean shouldDestroyReference(T t) {
        return false;
    }
}

