/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ObservableList<E>
implements List<E> {
    private final List<E> mList;
    private final Callback<E> mCallback;

    public ObservableList(List<E> mList, Callback<E> mCallback) {
        this.mList = mList;
        this.mCallback = mCallback;
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mList.contains(o);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.mList.toArray();
    }

    @Override
    @NonNull
    public <T> T[] toArray(T[] a) {
        return this.mList.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mList.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mList.retainAll(c);
    }

    @Override
    public E get(int index) {
        return this.mList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.mList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.mList.lastIndexOf(o);
    }

    @Override
    @NonNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.mList.subList(fromIndex, toIndex);
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return new ListIteratorImpl(this.mList.listIterator());
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator() {
        return new ListIteratorImpl(this.mList.listIterator());
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator(int index) {
        return new ListIteratorImpl(this.mList.listIterator(index));
    }

    @Override
    public boolean add(E e) {
        boolean result = this.mList.add(e);
        if (result) {
            this.mCallback.onAdd(this, this.mList.size() - 1, e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.mList.indexOf(o);
        if (index >= 0) {
            E old = this.mList.remove(index);
            this.mCallback.onRemove(this, index, old);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int startIndex = this.mList.size();
        boolean result = this.mList.addAll(c);
        if (result) {
            this.mCallback.onBatchAdd(this, startIndex, c);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends E> c) {
        boolean result = this.mList.addAll(index, c);
        if (result) {
            this.mCallback.onBatchAdd(this, index, c);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.mList.removeAll(c);
        if (result) {
            this.mCallback.onBatchRemove(this, c);
        }
        return result;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            List<E> list = this.obtainList();
            list.addAll(this.mList);
            this.mList.clear();
            this.mCallback.onClear(this, list);
        }
    }

    @Override
    public E set(int index, E element) {
        E old = this.mList.set(index, element);
        this.mCallback.onSet(this, index, old, element);
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.mList.add(index, element);
        this.mCallback.onAdd(this, index, element);
    }

    @Override
    public E remove(int index) {
        E old = this.mList.remove(index);
        this.mCallback.onRemove(this, index, old);
        return old;
    }

    protected List<E> obtainList() {
        return new ArrayList();
    }

    public void notifyUpdate(int index) {
        this.mCallback.onUpdate(this, index, this.mList.get(index));
    }

    public void notifyUpdate(int index, E e) {
        this.mCallback.onUpdate(this, index, e);
    }

    public void notifyUpdate(E e) {
        this.mCallback.onUpdate(this, this.mList.indexOf(e), e);
    }

    public void notifyBatchChanged(List<E> batch) {
        this.mCallback.onBatchChanged(this, batch);
    }

    public void notifyAllChanged() {
        this.mCallback.onAllChanged(this);
    }

    public static class SimpleCallback<T>
    implements Callback<T> {
        @Override
        public void onRemove(ObservableList<T> origin, int index, T ele) {
        }

        @Override
        public void onAdd(ObservableList<T> origin, int index, T ele) {
        }

        @Override
        public void onSet(ObservableList<T> origin, int index, T old, T newE) {
        }

        @Override
        public void onClear(ObservableList<T> origin, List<T> old) {
        }

        @Override
        public void onBatchRemove(ObservableList<T> origin, Collection<T> batch) {
        }

        @Override
        public void onBatchAdd(ObservableList<T> origin, int startIndex, Collection<T> batch) {
        }

        @Override
        public void onUpdate(ObservableList<T> origin, int index, T ele) {
        }

        @Override
        public void onBatchChanged(ObservableList<T> origin, List<T> batch) {
        }

        @Override
        public void onAllChanged(ObservableList<T> origin) {
        }
    }

    private class ListIteratorImpl
    implements ListIterator<E> {
        private final ListIterator<E> base;

        public ListIteratorImpl(ListIterator<E> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public E next() {
            return this.base.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.base.hasPrevious();
        }

        @Override
        public E previous() {
            return this.base.previous();
        }

        @Override
        public int nextIndex() {
            return this.base.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.base.previousIndex();
        }

        @Override
        public void remove() {
            int index = this.base.nextIndex();
            Object e = ObservableList.this.get(index);
            this.base.remove();
            ObservableList.this.mCallback.onRemove(ObservableList.this, index, e);
        }

        @Override
        public void set(E e) {
            int index = this.base.nextIndex();
            Object old = ObservableList.this.get(index);
            this.base.set(e);
            ObservableList.this.mCallback.onSet(ObservableList.this, index, old, e);
        }

        @Override
        public void add(E e) {
            int index = this.base.nextIndex();
            this.base.add(e);
            ObservableList.this.mCallback.onAdd(ObservableList.this, index, e);
        }
    }

    public static interface Callback<E> {
        public void onRemove(ObservableList<E> var1, int var2, E var3);

        public void onAdd(ObservableList<E> var1, int var2, E var3);

        public void onSet(ObservableList<E> var1, int var2, E var3, E var4);

        public void onClear(ObservableList<E> var1, List<E> var2);

        public void onBatchRemove(ObservableList<E> var1, Collection<E> var2);

        public void onBatchAdd(ObservableList<E> var1, int var2, Collection<E> var3);

        public void onUpdate(ObservableList<E> var1, int var2, E var3);

        public void onBatchChanged(ObservableList<E> var1, List<E> var2);

        public void onAllChanged(ObservableList<E> var1);
    }
}

