/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.NeedAndroidImpl;
import com.heaven7.java.base.util.DefaultPrinter;
import com.heaven7.java.base.util.Platforms;
import com.heaven7.java.base.util.Printer;
import com.heaven7.java.base.util.Throwables;

@NeedAndroidImpl(value="org.heaven7.android.base.impl.PrinterImpl")
public class Logger {
    static final String ANDROID_NAME = "org.heaven7.android.base.impl.PrinterImpl";
    private static int sLOG_LEVEL = 6;
    public static final int VERBOSE = 5;
    public static final int DEBUG = 4;
    public static final int INFO = 3;
    public static final int WARNING = 2;
    public static final int ERROR = 1;
    public static boolean IsDebug = true;
    private static final Printer sPrinter;

    public static void setDebug(boolean debug) {
        IsDebug = debug;
        if (debug) {
            Logger.setLevel(5);
        } else {
            Logger.setLevel(3);
        }
    }

    public static void setLevel(int lowestLevel) {
        switch (lowestLevel) {
            case 5: {
                sLOG_LEVEL = 6;
                break;
            }
            case 4: {
                sLOG_LEVEL = 5;
                break;
            }
            case 3: {
                sLOG_LEVEL = 4;
                break;
            }
            case 1: 
            case 2: {
                sLOG_LEVEL = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("caused by log lowestLevel=" + lowestLevel);
            }
        }
    }

    public static void v(String tag, String msg) {
        if (sLOG_LEVEL > 5) {
            sPrinter.verbose(tag, "", msg);
        }
    }

    public static void v(String tag, String methodTag, String msg) {
        if (sLOG_LEVEL > 5) {
            sPrinter.verbose(tag, methodTag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (sLOG_LEVEL > 4) {
            sPrinter.debug(tag, "", msg);
        }
    }

    public static void d(String tag, String methodTag, String msg) {
        if (sLOG_LEVEL > 4) {
            sPrinter.debug(tag, methodTag, msg);
        }
    }

    public static void i(String tag, String msg) {
        if (sLOG_LEVEL > 3) {
            sPrinter.info(tag, "", msg);
        }
    }

    public static void i(String tag, String methodTag, String msg) {
        if (sLOG_LEVEL > 3) {
            sPrinter.info(tag, methodTag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (sLOG_LEVEL > 2) {
            sPrinter.warn(tag, "", msg);
        }
    }

    public static void w(String tag, String methodTag, String msg) {
        if (sLOG_LEVEL > 2) {
            sPrinter.warn(tag, methodTag, msg);
        }
    }

    public static void w(String tag, Throwable throwable) {
        if (sLOG_LEVEL > 2) {
            sPrinter.warn(tag, "", throwable);
        }
    }

    public static void e(String tag, String msg) {
        if (sLOG_LEVEL > 1) {
            sPrinter.error(tag, "", msg);
        }
    }

    public static void e(String tag, String methodTag, String msg) {
        if (sLOG_LEVEL > 1) {
            sPrinter.error(tag, methodTag, msg);
        }
    }

    public static String toString(Throwable e) {
        return Throwables.getStackTraceAsString(e);
    }

    static {
        switch (Platforms.getSystemType()) {
            case 1: 
            case 2: 
            case 3: {
                sPrinter = DefaultPrinter.getDefault();
                break;
            }
            case 4: {
                try {
                    sPrinter = (Printer)Class.forName(ANDROID_NAME).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new UnsupportedOperationException("system type = " + Platforms.getSystemType());
            }
        }
    }
}

