/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.Throwables;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BatchProcessor {
    private final AtomicInteger mCount = new AtomicInteger();
    private final AtomicBoolean mMarkDone = new AtomicBoolean();
    private final AtomicBoolean mDoing = new AtomicBoolean();

    public final void addCount(int delta) {
        int cur = this.mCount.get();
        while (!this.mCount.compareAndSet(cur, cur + delta)) {
        }
    }

    public final int getCount() {
        return this.mCount.get();
    }

    public void markStart() {
        if (!this.mDoing.compareAndSet(false, true)) {
            throw new IllegalStateException("already doing");
        }
    }

    public void markEnd() {
        if (!this.mMarkDone.compareAndSet(false, true)) {
            throw new IllegalStateException("markEnd() already called.");
        }
        this.checkDone();
    }

    public void onTasksEnd(int delta) {
        Throwables.checkNonPositiveValue(delta);
        this.addCount(-delta);
        this.checkDone();
    }

    protected void checkDone() {
        if (this.mMarkDone.get() && this.mCount.get() == 0) {
            this.onDone();
            this.reset();
        }
    }

    protected void reset() {
        this.mCount.set(0);
        this.mMarkDone.set(false);
        this.mDoing.set(false);
    }

    protected abstract void onDone();
}

