/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ArrayUtils {
    public static <T> T[] toArray(T t) {
        Object array = Array.newInstance(t.getClass(), 1);
        Array.set(array, 0, t);
        return (Object[])array;
    }

    public static <T> T[] toArray(T t1, T t2) {
        Object array = Array.newInstance(t1.getClass(), 2);
        Array.set(array, 0, t1);
        Array.set(array, 1, t2);
        return (Object[])array;
    }

    public static <T> T[] toArray(T t1, T t2, T t3) {
        Object array = Array.newInstance(t1.getClass(), 3);
        Array.set(array, 0, t1);
        Array.set(array, 1, t2);
        Array.set(array, 2, t3);
        return (Object[])array;
    }

    public static <T> T[] toArray(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object array = Array.newInstance(list.get(0).getClass(), size);
        for (int i = size - 1; i >= 0; --i) {
            Array.set(array, i, list.get(i));
        }
        return (Object[])array;
    }

    public static int[] toIntArray(Collection<Integer> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        int[] arr = new int[coll.size()];
        Iterator<Integer> it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            arr[i++] = it.next();
        }
        return arr;
    }

    public static List<Integer> toList(int[] arr) {
        return ArrayUtils.toList(arr, null);
    }

    public static List<Integer> toList(int[] arr, List<Integer> out) {
        if (out == null) {
            out = new ArrayList<Integer>();
        }
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            out.add(arr[i]);
        }
        return out;
    }
}

