/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Util;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private final int index;
    private final int count;
    private final Class<?> resultType;
    private final MethodHandle collector;

    public Collect(MethodType source, int index, Class<?> resultType) {
        this.source = source;
        this.index = index;
        this.count = source.parameterCount() - index;
        this.resultType = resultType;
        this.collector = null;
    }

    public Collect(MethodType source, int index, Class<?> resultType, MethodHandle collector) {
        this.source = source;
        this.index = index;
        this.count = source.parameterCount() - index;
        this.resultType = resultType;
        this.collector = collector;
    }

    public Collect(MethodType source, int index, int count, Class<?> resultType) {
        this.source = source;
        this.index = index;
        this.count = count;
        this.resultType = resultType;
        this.collector = null;
    }

    public Collect(MethodType source, int index, int count, Class<?> resultType, MethodHandle collector) {
        this.source = source;
        this.index = index;
        this.count = count;
        this.resultType = resultType;
        this.collector = collector;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        if (this.collector == null) {
            if (Util.isJava9()) {
                return target.asCollector(this.index, this.resultType, this.count);
            }
            if (this.onlyTail()) {
                return target.asCollector(this.resultType, this.count);
            }
            Permutes permutes = this.buildPermutes(this.source, target.type());
            Binder binder = this.preparePermuteBinder(permutes);
            return binder.invoke(target);
        }
        return MethodHandles.collectArguments(target, this.index, this.collector);
    }

    private Binder preparePermuteBinder(Permutes permutes) {
        return Binder.from(this.source).permute(permutes.movePermute).collect(this.source.parameterCount() - this.count, this.resultType).permute(permutes.moveBackPermute);
    }

    @Override
    public MethodType down(MethodType type) {
        this.assertTypesAreCompatible();
        return type.dropParameterTypes(this.index, this.index + this.count).insertParameterTypes(this.index, this.resultType);
    }

    private void assertTypesAreCompatible() {
        if (this.collector == null) {
            assert (this.resultType.isArray()) : "no collector provided but target type is not array";
            Class<?> componentType = this.resultType.getComponentType();
            for (int i = this.index; i < this.index + this.count; ++i) {
                TypeDescriptor.OfField in = this.source.parameterType(i);
                assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                TypeDescriptor.OfField in = this.source.parameterType(this.index + i);
                TypeDescriptor.OfField out = this.collector.type().parameterType(i);
                assert (((Class)in).isAssignableFrom((Class<?>)out)) : "incoming type " + ((Class)in).getName() + " not compatible with " + out;
            }
            assert (((Class)this.collector.type().returnType()).isAssignableFrom(this.resultType));
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.resultType.getName();
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder();
        if (this.onlyTail()) {
            if (this.collector == null) {
                builder.append("handle = handle.asCollector(");
                Collect.buildClassArgument(builder, this.resultType);
                builder.append(", ").append(this.count).append(");");
            } else {
                builder.append("handle = MethodHandles.collectArguments(");
                builder.append("handle, ").append(this.count).append(", ");
                Collect.buildClassArgument(builder, this.resultType);
                builder.append(");");
            }
        } else {
            Permutes permutes = this.buildPermutes(this.source, incoming);
            Binder binder = this.preparePermuteBinder(permutes);
            return binder.toJava(incoming);
        }
        return builder.toString();
    }

    private boolean onlyTail() {
        return this.index + this.count == this.source.parameterCount();
    }

    private Permutes buildPermutes(MethodType source, MethodType target) {
        return new Permutes(source, target, this.index, this.count);
    }

    private static class Permutes {
        private final int[] movePermute;
        private final int[] moveBackPermute;

        private Permutes(MethodType source, MethodType target, int index, int count) {
            this.movePermute = new int[source.parameterCount()];
            this.moveBackPermute = new int[target.parameterCount()];
            for (int i = 0; i < index; ++i) {
                this.movePermute[i] = i;
                this.moveBackPermute[i] = i;
            }
            int shifted = 0;
            int i = index;
            while (i + count < this.movePermute.length) {
                this.movePermute[i] = i + count;
                ++i;
                ++shifted;
            }
            i = index;
            while (i + 1 < this.moveBackPermute.length) {
                this.moveBackPermute[i + 1] = i;
                ++i;
            }
            for (i = index + shifted; i < this.movePermute.length; ++i) {
                this.movePermute[i] = i - shifted;
            }
            this.moveBackPermute[index] = this.moveBackPermute.length - 1;
        }
    }
}

