/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.futuremind.recyclerviewfastscroll.RecyclerViewScrollListener;
import com.futuremind.recyclerviewfastscroll.SectionTitleProvider;
import com.futuremind.recyclerviewfastscroll.Utils;
import com.futuremind.recyclerviewfastscroll.viewprovider.DefaultScrollerViewProvider;
import com.futuremind.recyclerviewfastscroll.viewprovider.ScrollerViewProvider;
import com.hbb20.R;

public class FastScroller
extends LinearLayout {
    private static final int STYLE_NONE = -1;
    private final RecyclerViewScrollListener scrollListener = new RecyclerViewScrollListener(this);
    private RecyclerView recyclerView;
    private View bubble;
    private View handle;
    private TextView bubbleTextView;
    private int bubbleOffset;
    private int handleColor;
    private int bubbleColor;
    private int bubbleTextAppearance;
    private int scrollerOrientation;
    private int maxVisibility;
    private boolean manuallyChangingPosition;
    private ScrollerViewProvider viewProvider;
    private SectionTitleProvider titleProvider;

    public FastScroller(Context context) {
        this(context, null);
    }

    public FastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScroller(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setClipChildren(false);
        TypedArray style = context.obtainStyledAttributes(attrs, R.styleable.fastscroll__fastScroller, R.attr.fastscroll__style, 0);
        try {
            this.bubbleColor = style.getColor(R.styleable.fastscroll__fastScroller_fastscroll__bubbleColor, -1);
            this.handleColor = style.getColor(R.styleable.fastscroll__fastScroller_fastscroll__handleColor, -1);
            this.bubbleTextAppearance = style.getResourceId(R.styleable.fastscroll__fastScroller_fastscroll__bubbleTextAppearance, -1);
        }
        finally {
            style.recycle();
        }
        this.maxVisibility = this.getVisibility();
        this.setViewProvider(new DefaultScrollerViewProvider());
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        if (recyclerView.getAdapter() instanceof SectionTitleProvider) {
            this.titleProvider = (SectionTitleProvider)recyclerView.getAdapter();
        }
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.invalidateVisibility();
        recyclerView.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }

            public void onChildViewRemoved(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }
        });
    }

    public void setOrientation(int orientation) {
        this.scrollerOrientation = orientation;
        super.setOrientation(orientation == 0 ? 1 : 0);
    }

    public void setBubbleColor(int color) {
        this.bubbleColor = color;
        this.invalidate();
    }

    public void setHandleColor(int color) {
        this.handleColor = color;
        this.invalidate();
    }

    public void setBubbleTextAppearance(int textAppearanceResourceId) {
        this.bubbleTextAppearance = textAppearanceResourceId;
        this.invalidate();
    }

    public void addScrollerListener(RecyclerViewScrollListener.ScrollerListener listener) {
        this.scrollListener.addScrollerListener(listener);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.initHandleMovement();
        this.bubbleOffset = this.viewProvider.getBubbleOffset();
        this.applyStyling();
        if (!this.isInEditMode()) {
            this.scrollListener.updateHandlePosition(this.recyclerView);
        }
    }

    private void applyStyling() {
        if (this.bubbleColor != -1) {
            this.setBackgroundTint((View)this.bubbleTextView, this.bubbleColor);
        }
        if (this.handleColor != -1) {
            this.setBackgroundTint(this.handle, this.handleColor);
        }
        if (this.bubbleTextAppearance != -1) {
            TextViewCompat.setTextAppearance((TextView)this.bubbleTextView, (int)this.bubbleTextAppearance);
        }
    }

    private void setBackgroundTint(View view, int color) {
        Drawable background = DrawableCompat.wrap((Drawable)view.getBackground());
        if (background == null) {
            return;
        }
        DrawableCompat.setTint((Drawable)background.mutate(), (int)color);
        Utils.setBackground(view, background);
    }

    private void initHandleMovement() {
        this.handle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                FastScroller.this.requestDisallowInterceptTouchEvent(true);
                if (event.getAction() == 0 || event.getAction() == 2) {
                    if (FastScroller.this.titleProvider != null && event.getAction() == 0) {
                        FastScroller.this.viewProvider.onHandleGrabbed();
                    }
                    FastScroller.this.manuallyChangingPosition = true;
                    float relativePos = FastScroller.this.getRelativeTouchPosition(event);
                    FastScroller.this.setScrollerPosition(relativePos);
                    FastScroller.this.setRecyclerViewPosition(relativePos);
                    return true;
                }
                if (event.getAction() == 1) {
                    FastScroller.this.manuallyChangingPosition = false;
                    if (FastScroller.this.titleProvider != null) {
                        FastScroller.this.viewProvider.onHandleReleased();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private float getRelativeTouchPosition(MotionEvent event) {
        if (this.isVertical()) {
            float yInParent = event.getRawY() - Utils.getViewRawY(this.handle);
            return yInParent / (float)(this.getHeight() - this.handle.getHeight());
        }
        float xInParent = event.getRawX() - Utils.getViewRawX(this.handle);
        return xInParent / (float)(this.getWidth() - this.handle.getWidth());
    }

    public void setVisibility(int visibility) {
        this.maxVisibility = visibility;
        this.invalidateVisibility();
    }

    private void invalidateVisibility() {
        if (this.recyclerView.getAdapter() == null || this.recyclerView.getAdapter().getItemCount() == 0 || this.recyclerView.getChildAt(0) == null || this.isRecyclerViewNotScrollable() || this.maxVisibility != 0) {
            super.setVisibility(4);
        } else {
            super.setVisibility(0);
        }
    }

    private boolean isRecyclerViewNotScrollable() {
        if (this.isVertical()) {
            return this.recyclerView.getChildAt(0).getHeight() * this.recyclerView.getAdapter().getItemCount() <= this.recyclerView.getHeight();
        }
        return this.recyclerView.getChildAt(0).getWidth() * this.recyclerView.getAdapter().getItemCount() <= this.recyclerView.getWidth();
    }

    private void setRecyclerViewPosition(float relativePos) {
        if (this.recyclerView == null) {
            return;
        }
        int itemCount = this.recyclerView.getAdapter().getItemCount();
        int targetPos = (int)Utils.getValueInRange(0.0f, itemCount - 1, (int)(relativePos * (float)itemCount));
        this.recyclerView.scrollToPosition(targetPos);
        if (this.titleProvider != null && this.bubbleTextView != null) {
            this.bubbleTextView.setText((CharSequence)this.titleProvider.getSectionTitle(targetPos));
        }
    }

    void setScrollerPosition(float relativePos) {
        if (this.isVertical()) {
            this.bubble.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.bubble.getHeight(), relativePos * (float)(this.getHeight() - this.handle.getHeight()) + (float)this.bubbleOffset));
            this.handle.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.handle.getHeight(), relativePos * (float)(this.getHeight() - this.handle.getHeight())));
        } else {
            this.bubble.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.bubble.getWidth(), relativePos * (float)(this.getWidth() - this.handle.getWidth()) + (float)this.bubbleOffset));
            this.handle.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.handle.getWidth(), relativePos * (float)(this.getWidth() - this.handle.getWidth())));
        }
    }

    public boolean isVertical() {
        return this.scrollerOrientation == 1;
    }

    boolean shouldUpdateHandlePosition() {
        return this.handle != null && !this.manuallyChangingPosition && this.recyclerView.getChildCount() > 0;
    }

    ScrollerViewProvider getViewProvider() {
        return this.viewProvider;
    }

    public void setViewProvider(ScrollerViewProvider viewProvider) {
        this.removeAllViews();
        this.viewProvider = viewProvider;
        viewProvider.setFastScroller(this);
        this.bubble = viewProvider.provideBubbleView((ViewGroup)this);
        this.handle = viewProvider.provideHandleView((ViewGroup)this);
        this.bubbleTextView = viewProvider.provideBubbleTextView();
        this.addView(this.bubble);
        this.addView(this.handle);
    }
}

