/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.google.common.collect.ImmutableList;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;

public class SqlExtendedInsert
extends SqlInsert {
    private final SqlNodeList extendedKeywords;
    private SqlNodeList overrideColumnList;

    public SqlExtendedInsert(SqlNode table, SqlNode source, SqlNodeList keywords, SqlNodeList extendedKeywords, SqlNodeList columns, SqlParserPos pos) {
        super(pos, keywords, table, source, columns);
        this.extendedKeywords = extendedKeywords;
    }

    public ImmutableList<String> tableNames() {
        return ((SqlIdentifier)this.getTargetTable()).names;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        if (this.isSink()) {
            writer.keyword("SINK INTO");
        } else {
            writer.keyword("INSERT INTO");
        }
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        this.getSource().unparse(writer, 0, 0);
    }

    public SqlNodeList getTargetColumnList() {
        return this.overrideColumnList != null ? this.overrideColumnList : super.getTargetColumnList();
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        SqlValidatorTable table0 = validator.getCatalogReader().getTable(this.tableNames());
        if (table0 == null) {
            super.validate(validator, scope);
            assert (false);
        }
        HazelcastTable table = (HazelcastTable)table0.unwrap(HazelcastTable.class);
        if (this.getTargetColumnList() == null) {
            RelDataType rowType = table.getRowType(validator.getTypeFactory());
            ArrayList columnListWithoutHidden = new ArrayList();
            for (RelDataTypeField f2 : rowType.getFieldList()) {
                if (table.isHidden(f2.getName())) continue;
                columnListWithoutHidden.add(new SqlIdentifier(f2.getName(), SqlParserPos.ZERO));
            }
            this.overrideColumnList = new SqlNodeList(columnListWithoutHidden, SqlParserPos.ZERO);
        }
        super.validate(validator, scope);
        Map<String, TableField> fieldsMap = table.getTarget().getFields().stream().map(f -> (MapTableField)f).collect(Collectors.toMap(TableField::getName, f -> f));
        for (SqlNode fieldNode : this.getTargetColumnList()) {
            QueryPath path;
            TableField field = fieldsMap.get(((SqlIdentifier)fieldNode).getSimple());
            if (!(field instanceof MapTableField) || (path = ((MapTableField)field).getPath()).getPath() != null || field.getType().getTypeFamily() != QueryDataTypeFamily.OBJECT) continue;
            throw validator.newValidationError(fieldNode, ParserResource.RESOURCE.insertToTopLevelObject());
        }
        SqlConnector connector = SqlConnectorUtil.getJetSqlConnector(table.getTarget());
        if (this.isSink()) {
            if (!connector.supportsSink()) {
                throw validator.newValidationError((SqlNode)this, ParserResource.RESOURCE.sinkIntoNotSupported(connector.typeName()));
            }
        } else if (!connector.supportsInsert()) {
            throw validator.newValidationError((SqlNode)this, ParserResource.RESOURCE.insertIntoNotSupported(connector.typeName()));
        }
    }

    private boolean isSink() {
        for (SqlNode keyword : this.extendedKeywords) {
            if (((SqlLiteral)keyword).symbolValue(Keyword.class) != Keyword.SINK) continue;
            return true;
        }
        return false;
    }

    public static enum Keyword {
        SINK;


        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol((Enum)this, (SqlParserPos)pos);
        }
    }
}

