/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;

public class ValuesPhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelDataType rowType;
    private final List<Object[]> tuples;

    ValuesPhysicalRel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, List<Object[]> tuples) {
        super(cluster, traits);
        this.rowType = rowType;
        this.tuples = tuples;
    }

    public List<Object[]> tuples() {
        return this.tuples;
    }

    @Override
    public PlanNodeSchema schema() {
        return OptUtils.schema(this.getRowType());
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onValues(this);
    }

    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ValuesPhysicalRel(this.getCluster(), traitSet, this.rowType, this.tuples);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("tuples", (Object)this.tuples.stream().map(row -> Arrays.stream(row).map(String::valueOf).collect(Collectors.joining(", ", "{ ", " }"))).collect(Collectors.joining(", ", "[", "]")));
    }
}

