/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.jet.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MappingsTable
extends InfoSchemaTable {
    private static final String NAME = "mappings";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("mapping_catalog", QueryDataType.VARCHAR, false), new TableField("mapping_schema", QueryDataType.VARCHAR, false), new TableField("mapping_name", QueryDataType.VARCHAR, false), new TableField("mapping_external_name", QueryDataType.VARCHAR, false), new TableField("mapping_type", QueryDataType.VARCHAR, false), new TableField("mapping_options", QueryDataType.VARCHAR, false));
    private final String mappingsSchema;
    private final Collection<Mapping> mappings;

    public MappingsTable(String catalog, String schemaName, String mappingsSchema, Collection<Mapping> mappings) {
        super(FIELDS, catalog, schemaName, NAME, (TableStatistics)new ConstantTableStatistics((long)mappings.size()));
        this.mappingsSchema = mappingsSchema;
        this.mappings = mappings;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.mappings.size());
        for (Mapping mapping : this.mappings) {
            Object[] row = new Object[]{this.catalog(), this.mappingsSchema, mapping.name(), mapping.externalName(), mapping.type(), Util.uncheckCall(() -> JsonUtil.toJson(mapping.options()))};
            rows.add(row);
        }
        return rows;
    }
}

