/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.DistinctSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.io.IOException;
import java.math.BigDecimal;
import javax.annotation.concurrent.NotThreadSafe;

public final class SumSqlAggregations {
    private SumSqlAggregations() {
    }

    public static SqlAggregation from(QueryDataType operandType, boolean distinct) {
        SqlAggregation aggregation = SumSqlAggregations.from(operandType);
        return distinct ? new DistinctSqlAggregation(aggregation) : aggregation;
    }

    private static SqlAggregation from(QueryDataType operandType) {
        switch (operandType.getTypeFamily()) {
            case BIGINT: {
                return new SumLongSqlAggregation();
            }
            case DECIMAL: {
                return new SumDecimalSqlAggregation();
            }
            case REAL: {
                return new SumRealSqlAggregation();
            }
            case DOUBLE: {
                return new SumDoubleSqlAggregation();
            }
        }
        throw QueryException.error((String)("Unsupported operand type: " + operandType));
    }

    @NotThreadSafe
    private static final class SumDoubleSqlAggregation
    implements SqlAggregation {
        private double sum;
        private boolean initialized;

        private SumDoubleSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            if (value == null) {
                return;
            }
            this.sum += ((Double)value).doubleValue();
            this.initialized = true;
        }

        @Override
        public void combine(SqlAggregation other0) {
            SumDoubleSqlAggregation other = (SumDoubleSqlAggregation)other0;
            if (other.initialized) {
                this.accumulate(other.sum);
            }
        }

        @Override
        public Object collect() {
            return this.initialized ? Double.valueOf(this.sum) : null;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeDouble(this.sum);
            out.writeBoolean(this.initialized);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = in.readDouble();
            this.initialized = in.readBoolean();
        }
    }

    @NotThreadSafe
    private static final class SumRealSqlAggregation
    implements SqlAggregation {
        private float sum;
        private boolean initialized;

        private SumRealSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            if (value == null) {
                return;
            }
            this.sum += ((Float)value).floatValue();
            this.initialized = true;
        }

        @Override
        public void combine(SqlAggregation other0) {
            SumRealSqlAggregation other = (SumRealSqlAggregation)other0;
            if (other.initialized) {
                this.accumulate(Float.valueOf(other.sum));
            }
        }

        @Override
        public Object collect() {
            return this.initialized ? Float.valueOf(this.sum) : null;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeFloat(this.sum);
            out.writeBoolean(this.initialized);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = in.readFloat();
            this.initialized = in.readBoolean();
        }
    }

    @NotThreadSafe
    private static final class SumDecimalSqlAggregation
    implements SqlAggregation {
        private BigDecimal sum;

        private SumDecimalSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            if (value == null) {
                return;
            }
            if (this.sum == null) {
                this.sum = BigDecimal.ZERO;
            }
            this.sum = this.sum.add((BigDecimal)value, ExpressionMath.DECIMAL_MATH_CONTEXT);
        }

        @Override
        public void combine(SqlAggregation other0) {
            SumDecimalSqlAggregation other = (SumDecimalSqlAggregation)other0;
            this.accumulate(other.sum);
        }

        @Override
        public Object collect() {
            return this.sum;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.sum);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = (BigDecimal)in.readObject();
        }
    }

    @NotThreadSafe
    private static final class SumLongSqlAggregation
    implements SqlAggregation {
        private long sum;
        private boolean initialized;

        private SumLongSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            if (value == null) {
                return;
            }
            try {
                this.sum = Math.addExact(this.sum, (Long)value);
            }
            catch (ArithmeticException e) {
                throw QueryException.dataException((String)(QueryDataTypeFamily.BIGINT + " overflow in 'SUM' function (consider adding explicit CAST to DECIMAL)"));
            }
            this.initialized = true;
        }

        @Override
        public void combine(SqlAggregation other0) {
            SumLongSqlAggregation other = (SumLongSqlAggregation)other0;
            if (other.initialized) {
                this.accumulate(other.sum);
            }
        }

        @Override
        public Object collect() {
            return this.initialized ? Long.valueOf(this.sum) : null;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.sum);
            out.writeBoolean(this.initialized);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = in.readLong();
            this.initialized = in.readBoolean();
        }
    }
}

