/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators;

import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public class HazelcastOperandTypeInference
implements SqlOperandTypeInference {
    private final SqlTypeName[] namedOperandTypes;
    private final SqlOperandTypeInference positionalOperandTypeInference;

    public HazelcastOperandTypeInference(SqlTypeName[] namedOperandTypes, SqlOperandTypeInference positionalOperandTypeInference) {
        this.namedOperandTypes = namedOperandTypes;
        this.positionalOperandTypeInference = positionalOperandTypeInference;
    }

    public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
        if (ValidationUtil.hasAssignment(callBinding.getCall())) {
            assert (this.namedOperandTypes.length == operandTypes.length);
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                RelDataType operandType = typeFactory.createSqlType(this.namedOperandTypes[i]);
                operandTypes[i] = operandType.isNullable() ? HazelcastTypeUtils.createNullableType((RelDataTypeFactory)typeFactory, (RelDataType)operandType) : operandType;
            }
        } else {
            this.positionalOperandTypeInference.inferOperandTypes(callBinding, returnType, operandTypes);
        }
    }
}

