/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;

public class NamedOperandCheckerProgram {
    private final OperandChecker[] checkers;

    public NamedOperandCheckerProgram(OperandChecker ... checkers) {
        this.checkers = checkers;
    }

    public boolean check(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        boolean res = true;
        SqlCall call = callBinding.getCall();
        SqlFunction operator = (SqlFunction)call.getOperator();
        for (int i = 0; i < call.operandCount(); ++i) {
            SqlNode operand = call.operand(i);
            assert (operand.getKind() == SqlKind.ARGUMENT_ASSIGNMENT);
            SqlIdentifier id = (SqlIdentifier)((SqlCall)operand).operand(1);
            OperandChecker checker = this.findOperandChecker(id, operator);
            res &= checker.check(callBinding, false, i);
        }
        if (!res && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return res;
    }

    private OperandChecker findOperandChecker(SqlIdentifier identifier, SqlFunction operator) {
        String name = identifier.getSimple();
        for (int i = 0; i < operator.getParamNames().size(); ++i) {
            String paramName = (String)operator.getParamNames().get(i);
            if (!paramName.equals(name)) continue;
            return this.checkers[i];
        }
        throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), ValidatorResource.RESOURCE.unknownArgumentName(name));
    }
}

