/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.extract.JsonQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.JsonUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class KvMetadataJsonResolver
implements KvMetadataResolver {
    public static final KvMetadataJsonResolver INSTANCE = new KvMetadataJsonResolver();

    private KvMetadataJsonResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("json");
    }

    @Override
    public List<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        if (userFields.isEmpty()) {
            throw QueryException.error((String)"Column list is required for JSON format");
        }
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolvers.extractFields(userFields, isKey);
        LinkedHashMap<String, MappingField> fields = new LinkedHashMap<String, MappingField>();
        for (Map.Entry<QueryPath, MappingField> entry : userFieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            if (path.getPath() == null) {
                throw QueryException.error((String)("Cannot use the '" + path + "' field with JSON serialization"));
            }
            MappingField field = entry.getValue();
            fields.putIfAbsent(field.name(), field);
        }
        return new ArrayList<MappingField>(fields.values());
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> externalFieldsByPath = KvMetadataResolvers.extractFields(resolvedFields, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : externalFieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
        }
        KvMetadataResolvers.maybeAddDefaultField(isKey, resolvedFields, fields);
        return new KvMetadata(fields, JsonQueryTargetDescriptor.INSTANCE, JsonUpsertTargetDescriptor.INSTANCE);
    }
}

