/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.sql.impl.schema.Mapping;
import com.hazelcast.logging.ILogger;
import com.hazelcast.replicatedmap.impl.operation.GetOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class MappingStorage {
    private static final String CATALOG_MAP_NAME = "__sql.catalog";
    private static final int MAX_CHECK_ATTEMPTS = 5;
    private static final long SLEEP_MILLIS = 100L;
    private final NodeEngine nodeEngine;
    private final ILogger logger;

    public MappingStorage(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    void put(String name, Mapping mapping) {
        this.storage().put(name, mapping);
        this.awaitMappingOnAllMembers(name, mapping);
    }

    boolean putIfAbsent(String name, Mapping mapping) {
        Mapping previous = this.storage().putIfAbsent(name, mapping);
        this.awaitMappingOnAllMembers(name, mapping);
        return previous == null;
    }

    private void awaitMappingOnAllMembers(String name, Mapping mapping) {
        Data keyData = this.nodeEngine.getSerializationService().toData((Object)name);
        int keyPartitionId = this.nodeEngine.getPartitionService().getPartitionId(keyData);
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<Address> memberAddresses = this.getMemberAddresses();
        for (int i = 0; i < 5 && !memberAddresses.isEmpty(); ++i) {
            List futures = memberAddresses.stream().map(memberAddress -> {
                Operation operation = new GetOperation(CATALOG_MAP_NAME, keyData).setPartitionId(keyPartitionId).setValidateTarget(false);
                return operationService.createInvocationBuilder("hz:impl:replicatedMapService", operation, memberAddress).setTryCount(1).invoke().toCompletableFuture().thenApply(result -> Objects.equals(mapping, result) ? memberAddress : null);
            }).collect(Collectors.toList());
            for (CompletableFuture future : futures) {
                try {
                    memberAddresses.remove(future.join());
                }
                catch (Exception e) {
                    this.logger.warning("Error occurred while trying to fetch mapping: " + e.getMessage(), (Throwable)e);
                }
            }
            if (memberAddresses.isEmpty()) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private Collection<Address> getMemberAddresses() {
        return this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).stream().filter(member -> !member.localMember() && !member.isLiteMember()).map(Member::getAddress).collect(Collectors.toSet());
    }

    Collection<Mapping> values() {
        return this.storage().values();
    }

    boolean remove(String name) {
        return this.storage().remove(name) != null;
    }

    private Map<String, Mapping> storage() {
        return this.nodeEngine.getHazelcastInstance().getReplicatedMap(CATALOG_MAP_NAME);
    }
}

