/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.jet.sql.impl.schema.UnknownStatistic;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.type.SqlTypeName;

public final class FileTableFunction
extends JetTableFunction {
    public static final FileTableFunction CSV = new FileTableFunction("csv", Arrays.asList(new JetTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, true), new JetTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(3, "options", SqlTypeName.MAP, false)));
    public static final FileTableFunction JSON = new FileTableFunction("json", Arrays.asList(new JetTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, true), new JetTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(3, "options", SqlTypeName.MAP, false)));
    public static final FileTableFunction AVRO = new FileTableFunction("avro", Arrays.asList(new JetTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, true), new JetTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(3, "options", SqlTypeName.MAP, false)));
    public static final FileTableFunction PARQUET = new FileTableFunction("parquet", Arrays.asList(new JetTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, true), new JetTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, false), new JetTableFunctionParameter(3, "options", SqlTypeName.MAP, false)));
    private static final String SCHEMA_NAME_FILES = "files";
    private final String format;
    private final List<FunctionParameter> parameters;

    private FileTableFunction(String format, List<FunctionParameter> parameters) {
        super(FileSqlConnector.INSTANCE);
        this.format = format;
        this.parameters = parameters;
    }

    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    protected HazelcastTable toTable(List<Object> arguments) {
        Map<String, Object> options = this.toOptions(arguments);
        List<MappingField> fields = FileSqlConnector.resolveAndValidateFields(options, Collections.emptyList());
        Table table = FileSqlConnector.createTable(SCHEMA_NAME_FILES, FileTableFunction.randomName(), options, fields);
        return new HazelcastTable(table, (Statistic)UnknownStatistic.INSTANCE);
    }

    private Map<String, Object> toOptions(List<Object> arguments) {
        assert (arguments.size() == this.parameters.size());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("format", this.format);
        for (int i = 0; i < arguments.size(); ++i) {
            if (arguments.get(i) == null) continue;
            options.put(this.parameters.get(i).getName(), arguments.get(i));
        }
        return options;
    }

    private static String randomName() {
        return "file_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

