/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.CountSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SumSqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AvgSqlAggregation
extends SqlAggregation {
    private QueryDataType resultType;
    private SumSqlAggregation sum;
    private CountSqlAggregation count;

    private AvgSqlAggregation() {
    }

    public AvgSqlAggregation(int index, QueryDataType operandType) {
        this(index, operandType, false);
    }

    public AvgSqlAggregation(int index, QueryDataType operandType, boolean distinct) {
        super(index, true, distinct);
        this.resultType = AvgSqlAggregation.inferResultType(operandType);
        this.sum = new SumSqlAggregation(index, operandType);
        this.count = new CountSqlAggregation();
    }

    private static QueryDataType inferResultType(QueryDataType operandType) {
        switch (operandType.getTypeFamily()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return QueryDataType.DECIMAL;
            }
            case REAL: 
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
        }
        throw QueryException.error((String)("Unsupported operand type: " + operandType));
    }

    @Override
    public QueryDataType resultType() {
        return this.resultType;
    }

    @Override
    protected void accumulate(Object value) {
        this.sum.accumulate(value);
        this.count.accumulate(value);
    }

    @Override
    public void combine(SqlAggregation other0) {
        AvgSqlAggregation other = (AvgSqlAggregation)other0;
        this.sum.combine(other.sum);
        this.count.combine(other.count);
    }

    @Override
    public Object collect() {
        Object sum = this.sum.collect();
        if (sum == null) {
            return null;
        }
        Object count = this.count.collect();
        switch (this.resultType.getTypeFamily()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                BigDecimal decimalSum = this.sum.resultType().getConverter().asDecimal(sum);
                BigDecimal decimalCount = this.count.resultType().getConverter().asDecimal(count);
                return decimalSum.divide(decimalCount, ExpressionMath.DECIMAL_MATH_CONTEXT);
            }
        }
        assert (this.resultType.getTypeFamily() == QueryDataTypeFamily.DOUBLE);
        double doubleSum = this.sum.resultType().getConverter().asDouble(sum);
        double doubleCount = this.count.resultType().getConverter().asDouble(count);
        return doubleSum / doubleCount;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.resultType);
        out.writeObject((Object)this.sum);
        out.writeObject((Object)this.count);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.resultType = (QueryDataType)in.readObject();
        this.sum = (SumSqlAggregation)in.readObject();
        this.count = (CountSqlAggregation)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvgSqlAggregation that = (AvgSqlAggregation)o;
        return Objects.equals(this.resultType, that.resultType) && Objects.equals(this.sum, that.sum) && Objects.equals(this.count, that.count);
    }

    public int hashCode() {
        return Objects.hash(this.resultType, this.sum, this.count);
    }
}

