/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.python;

import com.hazelcast.jet.python.PythonServiceContext;
import com.hazelcast.logging.ILogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

class JetToPythonServer {
    private final File baseDir;
    private ILogger logger;
    private Process pythonProcess;
    private String pythonProcessPid;
    private Thread stdoutLoggingThread;

    JetToPythonServer(@Nonnull Path baseDir, @Nonnull ILogger logger) {
        this.baseDir = baseDir.toFile();
        this.logger = logger;
    }

    /*
     * Loose catch block
     */
    int start() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
            ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", String.format("./%s %d", "jet_to_python_main.sh", serverSocket.getLocalPort()));
            this.pythonProcess = builder.directory(this.baseDir).redirectErrorStream(true).start();
            this.stdoutLoggingThread = PythonServiceContext.logStdOut(this.logger, this.pythonProcess, "python-main");
            this.pythonProcessPid = PythonServiceContext.processPid(this.pythonProcess);
            this.logger.info("Started Python process: " + this.pythonProcessPid);
            serverSocket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            while (true) {
                int n;
                BufferedReader reader;
                Socket clientSocket;
                block20: {
                    clientSocket = serverSocket.accept();
                    reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
                    int serverPort = Integer.parseInt(reader.readLine());
                    this.logger.info("Python process " + this.pythonProcessPid + " listening on port " + serverPort);
                    n = serverPort;
                    reader.close();
                    if (clientSocket == null) break block20;
                    clientSocket.close();
                }
                return n;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Throwable throwable3) {
                                if (clientSocket != null) {
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                        }
                        catch (SocketTimeoutException e) {
                            if (this.pythonProcess.isAlive()) continue;
                            throw new IOException("Python process died before completing initialization", e);
                        }
                    }
                }
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="PrintStream wraps Python's stdin, not to be closed")
    void stop() {
        try {
            new PrintStream(this.pythonProcess.getOutputStream(), true, StandardCharsets.UTF_8.name()).println("stop");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.info("UTF_8 reported as unsupported encoding??");
        }
        boolean interrupted = false;
        while (true) {
            try {
                if (this.pythonProcess.waitFor(2L, TimeUnit.SECONDS)) {
                    break;
                }
            }
            catch (InterruptedException e) {
                this.logger.info("Ignoring interruption signal in order to prevent Python process leak");
                interrupted = true;
            }
            this.logger.warning("Python process " + this.pythonProcessPid + " still not done, sending a 'destroyForcibly' signal");
            this.pythonProcess.destroyForcibly();
        }
        while (true) {
            try {
                this.stdoutLoggingThread.join();
            }
            catch (InterruptedException e) {
                this.logger.info("Ignoring interruption signal in order to prevent thread leak (" + this.stdoutLoggingThread.getName() + ")");
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

