/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.spring.dao;

import com.hazelcast.jet.examples.spring.dao.UserDao;
import com.hazelcast.jet.examples.spring.model.User;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class UserDaoImpl
implements UserDao {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public User findByName(String name) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        String sql = "SELECT * FROM users WHERE name=:name";
        return (User)this.namedParameterJdbcTemplate.queryForObject(sql, params, (RowMapper)new UserMapper());
    }

    @Override
    public List<User> findAll() {
        String sql = "SELECT * FROM users";
        return this.namedParameterJdbcTemplate.query(sql, new HashMap(), (RowMapper)new UserMapper());
    }

    private static final class UserMapper
    implements RowMapper<User> {
        private UserMapper() {
        }

        public User mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new User().setId(rs.getInt("id")).setName(rs.getString("name")).setEmail(rs.getString("email"));
        }
    }
}

