/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sourcebuilder.support;

import com.hazelcast.jet.examples.sourcebuilder.support.MemoryUsageMetric;
import io.undertow.Undertow;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SystemMonitorHttpService {
    private final Runtime runtime = Runtime.getRuntime();
    private final BlockingQueue<MemoryUsageMetric> queue = new LinkedBlockingQueue<MemoryUsageMetric>();

    public SystemMonitorHttpService() {
        Thread t = new Thread(() -> {
            while (true) {
                long monitoredValue = this.runtime.totalMemory() - this.runtime.freeMemory();
                this.queue.add(new MemoryUsageMetric(System.currentTimeMillis(), monitoredValue));
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        t.setName("mock-system-monitor");
        t.setDaemon(true);
        t.start();
    }

    public Undertow httpServer() {
        return Undertow.builder().addHttpListener(8008, "localhost").setHandler(this::handleRequest).build();
    }

    private void handleRequest(HttpServerExchange exchange) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
        ArrayList tmpList = new ArrayList();
        this.queue.drainTo(tmpList);
        if (tmpList.isEmpty()) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (MemoryUsageMetric reading : tmpList) {
            b.append(reading.timestamp()).append(' ').append(reading.memoryUsage()).append('\n');
        }
        exchange.getResponseSender().send(b.toString());
    }
}

