/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sessionwindow;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.examples.sessionwindow.ProductEvent;
import com.hazelcast.jet.examples.sessionwindow.ProductEventType;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

class GenerateEventsP
extends AbstractProcessor {
    private final Random random = new Random();
    private UserTracker[] userTrackers = new UserTracker[5];
    private Traverser<ProductEvent> traverser;

    GenerateEventsP() {
    }

    public boolean isCooperative() {
        return false;
    }

    protected void init(@Nonnull Processor.Context context) {
        Arrays.setAll(this.userTrackers, i -> this.randomTracker());
    }

    public boolean complete() {
        this.initTraverserIfNeeded();
        this.emitFromTraverser(this.traverser);
        return false;
    }

    private void initTraverserIfNeeded() {
        if (this.traverser != null) {
            return;
        }
        Stream<ProductEvent> productEventStream = IntStream.range(0, this.userTrackers.length).filter(i -> this.random.nextInt(3) != 0).mapToObj(idx -> {
            ProductEvent event;
            UserTracker track = this.userTrackers[idx];
            if (track.remainingListings > 0) {
                --track.remainingListings;
                event = this.randomEvent(track.userId, ProductEventType.VIEW_LISTING);
            } else {
                --track.remainingPurchases;
                event = this.randomEvent(track.userId, ProductEventType.PURCHASE);
            }
            if (track.remainingListings == 0 && track.remainingPurchases == 0) {
                this.userTrackers[idx] = this.randomTracker();
            }
            return event;
        });
        this.traverser = Traversers.traverseStream(productEventStream).onFirstNull(() -> {
            this.traverser = null;
        });
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ProductEvent randomEvent(String userId, ProductEventType viewListing) {
        return new ProductEvent(System.currentTimeMillis(), userId, "product" + this.random.nextInt(20), viewListing);
    }

    private UserTracker randomTracker() {
        return new UserTracker(String.format("user%03d", this.random.nextInt(100)), this.random.nextInt(20), Math.max(0, this.random.nextInt(20) - 16));
    }

    private static final class UserTracker {
        final String userId;
        int remainingListings;
        int remainingPurchases;

        private UserTracker(String userId, int numListings, int numPurchases) {
            this.userId = userId;
            this.remainingListings = numListings;
            this.remainingPurchases = numPurchases;
        }
    }
}

