/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.rollingaggregation;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.examples.rollingaggregation.TradingVolumeGui;
import com.hazelcast.jet.examples.tradesource.Trade;
import com.hazelcast.jet.examples.tradesource.TradeSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.map.IMap;
import java.util.concurrent.TimeUnit;

public class TradingVolume {
    private static final String VOLUME_MAP_NAME = "volume-by-stock";
    private static final int TRADES_PER_SEC = 3000;
    private static final int NUMBER_OF_TICKERS = 20;
    private static final int DURATION_SECONDS = 60;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.readFrom(TradeSource.tradeStream((int)20, (int)3000)).withoutTimestamps().groupingKey(Trade::getTicker).rollingAggregate(AggregateOperations.summingLong(Trade::getQuantity)).writeTo(Sinks.map((String)VOLUME_MAP_NAME));
        return p;
    }

    public static void main(String[] args) throws Exception {
        JetInstance jet = Jet.bootstrappedInstance();
        new TradingVolumeGui((IMap<String, Long>)jet.getMap(VOLUME_MAP_NAME));
        try {
            Job job = jet.newJob(TradingVolume.buildPipeline());
            TimeUnit.SECONDS.sleep(60L);
            job.cancel();
            job.join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

