/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.patternmatching.support;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class TransactionStatusGui {
    public static final long PENDING_CODE = -1L;
    public static final long TIMED_OUT_CODE = -2L;
    private static final long COMPLETED_CODE = -3L;
    private static final int WINDOW_X = 400;
    private static final int WINDOW_Y = 100;
    private static final int WINDOW_WIDTH = 400;
    private static final int WINDOW_HEIGHT = 700;
    private static final long RETENTION_TIME_MS = TimeUnit.SECONDS.toMillis(3L);
    private static final int BORDER_SIZE = 10;
    private final List<TxInfo> guiModel = new ArrayList<TxInfo>();
    private final JFrame frame = new JFrame();

    public TransactionStatusGui(IMap<Long, Long> jetResults) {
        jetResults.addEntryListener((MapListener)((EntryAddedListener)this::onMapEvent), true);
        jetResults.addEntryListener((MapListener)((EntryUpdatedListener)this::onMapEvent), true);
        EventQueue.invokeLater(this::startGui);
    }

    private void onMapEvent(EntryEvent<Long, Long> event) {
        long transactionId = (Long)event.getKey();
        long value = (Long)event.getValue();
        EventQueue.invokeLater(() -> {
            TxInfo ti = this.guiModel.stream().filter(it -> it.transactionId == transactionId).findAny().orElseGet(() -> {
                TxInfo newTi = new TxInfo(transactionId);
                this.guiModel.add(newTi);
                return newTi;
            });
            ti.statusCode = value < 0L ? value : -3L;
            long l = ti.latency = value < 0L ? 0L : value;
            if (value != -1L) {
                ti.removeAt = System.currentTimeMillis() + RETENTION_TIME_MS;
            }
            this.frame.repaint();
        });
    }

    private void startGui() {
        this.frame.setBackground(Color.WHITE);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("Hazelcast Jet Pattern Matching Sample");
        this.frame.setBounds(400, 100, 400, 700);
        final JLabel[] labels = new JLabel[50];
        JPanel rootPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                int i;
                long now = System.currentTimeMillis();
                TransactionStatusGui.this.guiModel.removeIf(it -> it.removeAt <= now);
                int occupiedSlotCount = Math.min(labels.length, TransactionStatusGui.this.guiModel.size());
                for (i = 0; i < occupiedSlotCount; ++i) {
                    labels[i].setText(((TxInfo)TransactionStatusGui.this.guiModel.get(i)).text());
                    labels[i].setForeground(((TxInfo)TransactionStatusGui.this.guiModel.get(i)).textColor());
                }
                for (i = occupiedSlotCount; i < labels.length; ++i) {
                    labels[i].setText("");
                }
                super.paintComponent(g);
            }
        };
        rootPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        BoxLayout layout = new BoxLayout(rootPanel, 1);
        rootPanel.setLayout(layout);
        rootPanel.add(new JLabel("Transaction ID: status"));
        rootPanel.add(new JLabel("---------------------"));
        Arrays.setAll(labels, i -> new JLabel());
        for (JLabel l : labels) {
            rootPanel.add(l);
        }
        this.frame.add(rootPanel);
        this.frame.setVisible(true);
    }

    private static class TxInfo {
        long transactionId;
        long statusCode = -1L;
        long latency;
        long removeAt = Long.MAX_VALUE;

        TxInfo(long transactionId) {
            this.transactionId = transactionId;
        }

        String text() {
            return String.format("%,10d: %s", this.transactionId, this.statusCode == -3L ? String.format("TOOK %,d ms", this.latency) : (this.statusCode == -2L ? "TIMED OUT" : (this.statusCode == -1L ? "PENDING" : "ERROR, code = " + this.statusCode)));
        }

        Color textColor() {
            return this.statusCode == -3L ? Color.BLACK : (this.statusCode == -2L ? Color.RED : (this.statusCode == -1L ? Color.BLUE : Color.RED));
        }
    }
}

