/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rex;

import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexSqlConvertlet;
import com.hazelcast.shaded.org.apache.calcite.rex.RexSqlConvertletTable;
import com.hazelcast.shaded.org.apache.calcite.rex.RexToSqlNodeConverter;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.util.DateString;
import com.hazelcast.shaded.org.apache.calcite.util.NlsString;
import com.hazelcast.shaded.org.apache.calcite.util.TimeString;
import com.hazelcast.shaded.org.apache.calcite.util.TimestampString;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class RexToSqlNodeConverterImpl
implements RexToSqlNodeConverter {
    private final RexSqlConvertletTable convertletTable;

    public RexToSqlNodeConverterImpl(RexSqlConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    @Override
    public @Nullable SqlNode convertNode(RexNode node) {
        if (node instanceof RexLiteral) {
            return this.convertLiteral((RexLiteral)node);
        }
        if (node instanceof RexInputRef) {
            return this.convertInputRef((RexInputRef)node);
        }
        if (node instanceof RexCall) {
            return this.convertCall((RexCall)node);
        }
        return null;
    }

    @Override
    public @Nullable SqlNode convertCall(RexCall call) {
        RexSqlConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(this, call);
        }
        return null;
    }

    @Override
    public @Nullable SqlNode convertLiteral(RexLiteral literal) {
        if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createExactNumeric(String.valueOf(literal.getValue()), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createApproxNumeric(String.valueOf(literal.getValue()), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.TIMESTAMP.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createTimestamp(literal.getTypeName(), Objects.requireNonNull(literal.getValueAs(TimestampString.class), "literal.getValueAs(TimestampString.class)"), 0, SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.DATE.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createDate(Objects.requireNonNull(literal.getValueAs(DateString.class), "literal.getValueAs(DateString.class)"), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.TIME.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createTime(Objects.requireNonNull(literal.getValueAs(TimeString.class), "literal.getValueAs(TimeString.class)"), 0, SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.CHARACTER.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createCharString(Objects.requireNonNull((NlsString)literal.getValue(), "literal.getValue()").getValue(), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.BOOLEAN.getTypeNames().contains((Object)literal.getTypeName())) {
            return SqlLiteral.createBoolean((Boolean)Objects.requireNonNull(literal.getValue(), "literal.getValue()"), SqlParserPos.ZERO);
        }
        if (SqlTypeFamily.NULL == literal.getTypeName().getFamily()) {
            return SqlLiteral.createNull(SqlParserPos.ZERO);
        }
        return null;
    }

    @Override
    public @Nullable SqlNode convertInputRef(RexInputRef ref) {
        return null;
    }
}

