/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.model.JsonMeasure;
import com.hazelcast.shaded.org.apache.calcite.model.JsonTile;
import com.hazelcast.shaded.org.apache.calcite.model.ModelHandler;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class JsonLattice {
    public final String name;
    public final Object sql;
    public final boolean auto;
    public final boolean algorithm;
    public final long algorithmMaxMillis;
    public final @Nullable Double rowCountEstimate;
    public final @Nullable String statisticProvider;
    public final List<JsonTile> tiles = new ArrayList<JsonTile>();
    public final List<JsonMeasure> defaultMeasures;

    @JsonCreator
    public JsonLattice(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="sql", required=true) Object sql, @JsonProperty(value="auto") @Nullable Boolean auto, @JsonProperty(value="algorithm") @Nullable Boolean algorithm, @JsonProperty(value="algorithmMaxMillis") @Nullable Long algorithmMaxMillis, @JsonProperty(value="rowCountEstimate") @Nullable Double rowCountEstimate, @JsonProperty(value="statisticProvider") @Nullable String statisticProvider, @JsonProperty(value="defaultMeasures") @Nullable List<JsonMeasure> defaultMeasures) {
        this.name = Objects.requireNonNull(name, "name");
        this.sql = Objects.requireNonNull(sql, "sql");
        this.auto = auto == null || auto != false;
        this.algorithm = algorithm != null && algorithm != false;
        this.algorithmMaxMillis = algorithmMaxMillis == null ? -1L : algorithmMaxMillis;
        this.rowCountEstimate = rowCountEstimate;
        this.statisticProvider = statisticProvider;
        this.defaultMeasures = defaultMeasures == null ? ImmutableList.of(new JsonMeasure("count", null)) : defaultMeasures;
    }

    public void accept(ModelHandler handler) {
        handler.visit(this);
    }

    public String toString() {
        return "JsonLattice(name=" + this.name + ", sql=" + this.getSql() + ")";
    }

    public String getSql() {
        return JsonLattice.toString(this.sql);
    }

    static String toString(Object o) {
        Objects.requireNonNull(o, "argument must not be null");
        return o instanceof String ? (String)o : JsonLattice.concatenate((List)o);
    }

    private static String concatenate(List<?> list) {
        StringJoiner buf = new StringJoiner("\n", "", "\n");
        for (Object o : list) {
            if (!(o instanceof String)) {
                throw new RuntimeException("each element of a string list must be a string; found: " + o);
            }
            buf.add((String)o);
        }
        return buf.toString();
    }

    public void visitChildren(ModelHandler modelHandler) {
        for (JsonMeasure jsonMeasure : this.defaultMeasures) {
            jsonMeasure.accept(modelHandler);
        }
        for (JsonTile jsonTile : this.tiles) {
            jsonTile.accept(modelHandler);
        }
    }
}

