/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.DataConnectionsTable;
import com.hazelcast.jet.sql.impl.schema.DataConnectionStorage;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DataConnectionResolver
implements TableResolver {
    private static final List<List<String>> SEARCH_PATHS = Collections.singletonList(Arrays.asList("hazelcast", "public"));
    private static final List<TriFunction<List<DataConnectionCatalogEntry>, SqlConnectorCache, Boolean, Table>> ADDITIONAL_TABLE_PRODUCERS = Collections.singletonList((TriFunction & Serializable)(dl, connectorCache, securityEnabled) -> new DataConnectionsTable("hazelcast", "information_schema", "public", (Collection<DataConnectionCatalogEntry>)dl, (SqlConnectorCache)connectorCache, (boolean)securityEnabled));
    private final DataConnectionStorage dataConnectionStorage;
    private final DataConnectionServiceImpl dataConnectionService;
    private final SqlConnectorCache connectorCache;
    private final boolean isSecurityEnabled;
    private final CopyOnWriteArrayList<TableResolver.TableListener> listeners;

    public DataConnectionResolver(InternalDataConnectionService dataConnectionService, SqlConnectorCache connectorCache, DataConnectionStorage dataConnectionStorage, boolean isSecurityEnabled) {
        Preconditions.checkInstanceOf(DataConnectionServiceImpl.class, (Object)dataConnectionService);
        this.dataConnectionService = (DataConnectionServiceImpl)dataConnectionService;
        this.dataConnectionStorage = dataConnectionStorage;
        this.connectorCache = connectorCache;
        this.isSecurityEnabled = isSecurityEnabled;
        this.listeners = new CopyOnWriteArrayList();
    }

    public boolean createDataConnection(DataConnectionCatalogEntry dl, boolean replace, boolean ifNotExists) {
        if (replace) {
            this.dataConnectionStorage.put(dl.name(), dl);
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
            return true;
        }
        boolean added = this.dataConnectionStorage.putIfAbsent(dl.name(), dl);
        if (!added && !ifNotExists) {
            throw QueryException.error((String)("Data connection already exists: " + dl.name()));
        }
        if (!added) {
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        }
        return added;
    }

    public void removeDataConnection(String name, boolean ifExists) {
        if (!this.dataConnectionStorage.removeDataConnection(name)) {
            if (!ifExists) {
                throw QueryException.error((String)("Data connection does not exist: " + name));
            }
        } else {
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        }
    }

    public void invokeChangeListeners() {
        this.listeners.forEach(TableResolver.TableListener::onTableChanged);
    }

    @Override
    @Nonnull
    public List<List<String>> getDefaultSearchPaths() {
        return SEARCH_PATHS;
    }

    @Override
    @Nonnull
    public List<Table> getTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        ADDITIONAL_TABLE_PRODUCERS.forEach(producer -> tables.add((Table)producer.apply(DataConnectionResolver.getAllDataConnectionEntries(this.dataConnectionService, this.dataConnectionStorage), (Object)this.connectorCache, (Object)this.isSecurityEnabled)));
        return tables;
    }

    public static List<DataConnectionCatalogEntry> getAllDataConnectionEntries(DataConnectionServiceImpl dataConnectionService, DataConnectionStorage dataConnectionStorage) {
        List<DataConnectionCatalogEntry> dataConnections = dataConnectionService.getConfigCreatedDataConnections().stream().map(dc -> new DataConnectionCatalogEntry(dc.getName(), dataConnectionService.typeForDataConnection(dc.getName()), dc.getConfig().isShared(), dc.options(), DataConnectionServiceImpl.DataConnectionSource.CONFIG)).collect(Collectors.toList());
        dataConnections.addAll(dataConnectionStorage.dataConnections());
        return dataConnections;
    }

    public static List<List<?>> getAllDataConnectionNameWithTypes(DataConnectionServiceImpl dataConnectionService) {
        ArrayList conn = new ArrayList();
        conn.addAll(dataConnectionService.getConfigCreatedDataConnections());
        conn.addAll(dataConnectionService.getSqlCreatedDataConnections());
        return conn.stream().map(dc -> Arrays.asList(dc.getName(), dc.getConfig().getType(), DataConnectionResolver.jsonArray(dc.resourceTypes()))).collect(Collectors.toList());
    }

    private static HazelcastJsonValue jsonArray(Collection<String> values) {
        return new HazelcastJsonValue(Json.array((String[])values.toArray(new String[0])).toString());
    }

    @Override
    public void registerListener(TableResolver.TableListener listener) {
        this.listeners.add(listener);
    }
}

