/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapEvent;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Collection;

public abstract class AbstractSchemaStorage {
    protected final NodeEngine nodeEngine;

    AbstractSchemaStorage(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    void initializeWithListener(EntryListener<String, Object> listener) {
        if (!this.nodeEngine.getLocalMember().isLiteMember()) {
            this.storage().addEntryListener(listener, false);
        }
    }

    Collection<Object> allObjects() {
        return this.storage().values();
    }

    IMap<String, Object> storage() {
        return this.nodeEngine.getHazelcastInstance().getMap("__sql.catalog");
    }

    static abstract class EntryListenerAdapter
    implements EntryListener<String, Object> {
        EntryListenerAdapter() {
        }

        public final void entryAdded(EntryEvent<String, Object> event) {
        }

        public abstract void entryUpdated(EntryEvent<String, Object> var1);

        public abstract void entryRemoved(EntryEvent<String, Object> var1);

        public final void entryEvicted(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be evicted - " + String.valueOf(event));
        }

        public void entryExpired(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be expired - " + String.valueOf(event));
        }

        public final void mapCleared(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be cleared - " + String.valueOf(event));
        }

        public final void mapEvicted(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be evicted - " + String.valueOf(event));
        }
    }
}

