/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.TransformBatchedAutoCloseableP;
import com.hazelcast.jet.impl.util.AutoCloseableTraverser;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

abstract class AbstractJoinProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    protected String query;
    protected List<FunctionEx<Object, ?>> converters;
    protected JetJoinInfo joinInfo;
    protected List<Expression<?>> projections;
    protected transient ExpressionEvalContext expressionEvalContext;

    AbstractJoinProcessorSupplier() {
    }

    AbstractJoinProcessorSupplier(@Nonnull String dataConnectionName, @Nonnull String query, @Nonnull List<FunctionEx<Object, ?>> converters, @Nonnull JetJoinInfo joinInfo, List<Expression<?>> projections) {
        super(dataConnectionName);
        this.query = query;
        this.converters = converters;
        this.joinInfo = joinInfo;
        this.projections = projections;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.expressionEvalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return IntStream.range(0, count).mapToObj(i -> new TransformBatchedAutoCloseableP(this::joinRows).setCooperative(false)).collect(Collectors.toList());
    }

    protected abstract AutoCloseableTraverser<JetSqlRow> joinRows(Iterable<JetSqlRow> var1);

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataConnectionName);
        out.writeString(this.query);
        out.writeObject(this.converters);
        out.writeObject((Object)this.joinInfo);
        out.writeObject(this.projections);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dataConnectionName = in.readString();
        this.query = in.readString();
        this.converters = (List)in.readObject();
        this.joinInfo = (JetJoinInfo)in.readObject();
        this.projections = (List)in.readObject();
    }
}

