/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.hprtree.HPRtree;
import com.hazelcast.shaded.org.locationtech.jts.index.quadtree.Quadtree;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.List;
import test.jts.perf.index.EnvelopeList;
import test.jts.perf.index.Index;
import test.jts.perf.index.IndexTester;

public class TreeTimeTest {
    public static final int NUM_ITEMS = 100000;

    public static void main(String[] args) throws Exception {
        int n = 100000;
        TreeTimeTest test = new TreeTimeTest();
        List items = IndexTester.createRandomBoxes(n);
        List queries = IndexTester.createRandomBoxes(n);
        System.out.println("----------------------------------------------");
        System.out.println("Dummy run to ensure classes are loaded before real run");
        System.out.println("----------------------------------------------");
        test.run(items, queries);
        System.out.println("----------------------------------------------");
        System.out.println("Real run");
        System.out.println("----------------------------------------------");
        test.run(items, queries);
    }

    public List run(List items, List queries) throws Exception {
        ArrayList<IndexTester.IndexResult> indexResults = new ArrayList<IndexTester.IndexResult>();
        System.out.println("# items = " + items.size());
        indexResults.add(this.run(new HPRtreeIndex(16), items, queries));
        indexResults.add(this.run(new STRtreeIndex(4), items, queries));
        return indexResults;
    }

    public IndexTester.IndexResult run(Index index, List items, List queries) throws Exception {
        return new IndexTester(index).testAll(items, queries);
    }

    class EnvelopeListIndex
    implements Index {
        EnvelopeList index = new EnvelopeList();

        EnvelopeListIndex() {
        }

        public String toString() {
            return "Env";
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.add(itemEnv);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
        }
    }

    class QuadtreeIndex
    implements Index {
        Quadtree index = new Quadtree();

        QuadtreeIndex() {
        }

        public String toString() {
            return "Quad";
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.insert(itemEnv, item);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
        }
    }

    class HPRtreeIndex
    implements Index {
        private int nodeCapacity;
        HPRtree index;

        public HPRtreeIndex(int nodeCapacity) {
            this.nodeCapacity = nodeCapacity;
            this.index = new HPRtree(nodeCapacity);
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.insert(itemEnv, item);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
            this.index.build();
        }

        public String toString() {
            return "HPR[M=" + this.nodeCapacity + "]";
        }
    }

    class STRtreeIndex
    implements Index {
        STRtree index;

        public String toString() {
            return "STR[M=" + this.index.getNodeCapacity() + "]";
        }

        public STRtreeIndex(int nodeCapacity) {
            this.index = new STRtree(nodeCapacity);
        }

        @Override
        public void insert(Envelope itemEnv, Object item) {
            this.index.insert(itemEnv, item);
        }

        @Override
        public List query(Envelope searchEnv) {
            return this.index.query(searchEnv);
        }

        @Override
        public void finishInserting() {
            this.index.build();
        }
    }
}

