/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;

public class PointInAreaStressTester {
    private GeometryFactory geomFactory;
    private Geometry area;
    private boolean ignoreBoundaryResults = true;
    private int numPts = 10000;
    private PointOnGeometryLocator pia1;
    private PointOnGeometryLocator pia2;
    private int[] locationCount = new int[3];

    public PointInAreaStressTester(GeometryFactory geomFactory, Geometry area) {
        this.geomFactory = geomFactory;
        this.area = area;
    }

    public void setNumPoints(int numPoints) {
        this.numPts = numPoints;
    }

    public void setPIA(PointOnGeometryLocator pia) {
        this.pia1 = pia;
    }

    public void setExpected(PointOnGeometryLocator pia) {
        this.pia2 = pia;
    }

    public void setIgnoreBoundaryResults(boolean ignoreBoundaryResults) {
        this.ignoreBoundaryResults = ignoreBoundaryResults;
    }

    public boolean run() {
        Stopwatch sw = new Stopwatch();
        if (this.pia2 == null) {
            this.pia2 = new SimplePointInAreaLocator(this.area);
        }
        int ptGridWidth = (int)Math.sqrt(this.numPts);
        Envelope areaEnv = this.area.getEnvelopeInternal();
        double xStep = areaEnv.getWidth() / (double)(ptGridWidth - 1);
        double yStep = areaEnv.getHeight() / (double)(ptGridWidth - 1);
        for (int i = 0; i < ptGridWidth; ++i) {
            for (int j = 0; j < ptGridWidth; ++j) {
                double x = areaEnv.getMinX() + (double)i * xStep;
                double y = areaEnv.getMinY() + (double)j * yStep;
                Coordinate pt = new Coordinate(x, y);
                this.geomFactory.getPrecisionModel().makePrecise(pt);
                boolean isEqual = this.testPIA(pt);
                if (isEqual) continue;
                return false;
            }
        }
        System.out.println("Test completed in " + sw.getTimeString());
        this.printStats();
        return true;
    }

    public void printStats() {
        System.out.println("Location counts:  Boundary = " + this.locationCount[1] + " Interior = " + this.locationCount[0] + " Exterior = " + this.locationCount[2]);
    }

    private boolean testPIA(Coordinate p) {
        int loc1 = this.pia1.locate(p);
        int loc2 = this.pia2.locate(p);
        int n = loc1;
        this.locationCount[n] = this.locationCount[n] + 1;
        if ((loc1 == 1 || loc2 == 1) && this.ignoreBoundaryResults) {
            return true;
        }
        return loc1 == loc2;
    }
}

